

The AEA framework provides the tools for creating Autonomous Economic Agents (AEA).

## What are AEAs?

We define an autonomous economic agent or AEA as:

> an intelligent agent acting on an owner's behalf, with limited or no interference, and whose goal is to generate economic value to its owner.

In short, "software that generates economic value for you".

<iframe width="560" height="315" src="https://www.youtube.com/embed/xpJA4IT5X88" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

AEAs act independently of constant user input and autonomously execute actions to achieve their goal. Their goal is to create economic value for you, their owner. AEAs have a wide range of <a href="app-areas">application areas</a> and we provide <a href="car-park-skills">demo guides</a> for some examples.

Autonomous Economic Agents are digital entities that run complex dynamic decision-making algorithms for application owners and clients.

AEAs are not:

* just any agents: AEAs have an express purpose to generate economic value in a multi-stakeholder environment.
* APIs or sensors which do not have agency.
* smart contracts which do not display any proactiveness and are purely reactive to external requests (=contract calls). 
* artificial general intelligence (AGI): AEAs can have a very narrow goal directed focus involving some economic gain and implemented via simple conditional logic.

## What is the AEA Framework?

The AEA framework is a Python-based development suite which equips you with an efficient and accessible set of tools for building AEAs. The framework is modular, extensible, and composable. This framework attempts to make agent development as straightforward an experience as possible, similar to web development using popular web frameworks.

To get started developing your own AEA, check out the <a href="quickstart">getting started</a> section.

To learn more about some of the distinctive characteristics of agent-oriented development, check out the guide on <a href="agent-oriented-development">agent-oriented development</a>.

If you would like to develop an AEA in a language different to Python then check out our <a href="language-agnostic-definition">language agnostic AEA definition</a>.

AEAs achieve their goals with the help of the <a href="oef-ledger">Open Economic Framework (OEF)</a> - a decentralized communication and search & discovery system for agents - and using <a href="oef-ledger">Fetch.ai's blockchain</a> as a financial settlement and commitment layer. Third-party blockchains, such as Ethereum, may also allow AEA integration.

<div class="admonition note">
  <p class="admonition-title">Note</p>
  <p>This developer documentation is a work in progress. If you spot any errors please open an issue <a href="https://github.com/fetchai/agents-aea" target="_blank">here</a>.</p>
</div>

<br />
