/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class MultiModelMojoReader<M extends MojoModel>
extends ModelMojoReader<M> {
    private Map<String, MojoModel> _subModels;

    @Override
    protected final void readModelData() throws IOException {
        int subModelCount = this.readkv("submodel_count", 0);
        HashMap<String, MojoModel> models = new HashMap<String, MojoModel>(subModelCount);
        for (int i2 = 0; i2 < subModelCount; ++i2) {
            String key = (String)this.readkv("submodel_key_" + i2);
            String zipDirectory = (String)this.readkv("submodel_dir_" + i2);
            MojoModel model = ModelMojoReader.readFrom(new NestedMojoReaderBackend(zipDirectory));
            models.put(key, model);
        }
        this._subModels = Collections.unmodifiableMap(models);
        this.readParentModelData();
    }

    protected MojoModel getModel(String key) {
        return this._subModels.get(key);
    }

    protected Map<String, MojoModel> getSubModels() {
        return this._subModels;
    }

    protected abstract void readParentModelData() throws IOException;

    private class NestedMojoReaderBackend
    implements MojoReaderBackend {
        private String _zipDirectory;

        private NestedMojoReaderBackend(String zipDirectory) {
            this._zipDirectory = zipDirectory;
        }

        @Override
        public BufferedReader getTextFile(String filename) throws IOException {
            return MultiModelMojoReader.this._reader.getTextFile(this._zipDirectory + filename);
        }

        @Override
        public byte[] getBinaryFile(String filename) throws IOException {
            return MultiModelMojoReader.this._reader.getBinaryFile(this._zipDirectory + filename);
        }

        @Override
        public boolean exists(String filename) {
            return MultiModelMojoReader.this._reader.exists(this._zipDirectory + filename);
        }
    }
}

