"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobQueue = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const batch_generated_1 = require("./batch.generated");
/**
 * Batch Job Queue.
 *
 * Defines a batch job queue to define how submitted batch jobs
 * should be ran based on specified batch compute environments.
 */
class JobQueue extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.jobQueueName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_batch_JobQueueProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.computeEnvironments.length === 0) {
            throw new Error('computeEnvironments must be non-empty');
        }
        const jobQueue = new batch_generated_1.CfnJobQueue(this, 'Resource', {
            computeEnvironmentOrder: props.computeEnvironments.map(cp => ({
                computeEnvironment: cp.computeEnvironment.computeEnvironmentArn,
                order: cp.order,
            })),
            jobQueueName: this.physicalName,
            priority: props.priority || 1,
            state: props.enabled === undefined ? 'ENABLED' : (props.enabled ? 'ENABLED' : 'DISABLED'),
        });
        this.jobQueueArn = this.getResourceArnAttribute(jobQueue.ref, {
            service: 'batch',
            resource: 'job-queue',
            resourceName: this.physicalName,
        });
        this.jobQueueName = this.getResourceNameAttribute(jobQueue.ref);
    }
    /**
     * Fetches an existing batch job queue by its amazon resource name.
     *
     * @param scope
     * @param id
     * @param jobQueueArn
     */
    static fromJobQueueArn(scope, id, jobQueueArn) {
        const stack = core_1.Stack.of(scope);
        const jobQueueName = stack.splitArn(jobQueueArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.jobQueueArn = jobQueueArn;
                this.jobQueueName = jobQueueName;
            }
        }
        return new Import(scope, id);
    }
}
exports.JobQueue = JobQueue;
_a = JSII_RTTI_SYMBOL_1;
JobQueue[_a] = { fqn: "@aws-cdk/aws-batch.JobQueue", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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