import { ApiObject, GroupVersionKind } from 'cdk8s';
import { Construct } from 'constructs';
import * as k8s from './imports/k8s';
export * as k8s from './imports/k8s';
/**
 * @experimental
 */
export interface AnalysisTemplate {
    /**
     * @experimental
     */
    readonly templateName: string;
}
/**
 * @experimental
 */
export interface ValueFrom {
    /**
     * @experimental
     */
    readonly podTemplateHashValue?: string;
    /**
     * @experimental
     */
    readonly fieldRef?: k8s.ObjectFieldSelector;
}
/**
 * @experimental
 */
export interface AnalysisArgs {
    /**
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    readonly value?: string;
    /**
     * @experimental
     */
    readonly valueFrom?: ValueFrom;
}
/**
 * @experimental
 */
export interface AnalysisSpec {
    /**
     * @experimental
     */
    readonly templates: AnalysisTemplate[];
    /**
     * @experimental
     */
    readonly args: AnalysisArgs[];
}
/**
 * @experimental
 */
export interface BlueGreenStrategySpecs {
    /**
     * @experimental
     */
    readonly activeService: string;
    /**
     * @experimental
     */
    readonly prePromotionAnalysis?: AnalysisSpec;
    /**
     * @experimental
     */
    readonly postPromotionAnalysis?: AnalysisSpec;
    /**
     * @experimental
     */
    readonly previewService?: string;
    /**
     * @experimental
     */
    readonly previewReplicaCount?: number;
    /**
     * @experimental
     */
    readonly autoPromotionEnabled?: boolean;
    /**
     * @experimental
     */
    readonly autoPromotionSeconds?: number;
    /**
     * @experimental
     */
    readonly scaleDownDelaySeconds?: number;
    /**
     * @experimental
     */
    readonly scaleDownDelayRevisionLimit?: number;
    /**
     * @experimental
     */
    readonly antiAffinity: k8s.PodAntiAffinity;
}
/**
 * @experimental
 */
export interface StrategySpecs {
    /**
     * @experimental
     */
    readonly blueGreen: BlueGreenStrategySpecs;
}
/**
 * @experimental
 */
export interface ArgoSpecs {
    /**
     * @experimental
     */
    readonly strategy: StrategySpecs;
    /**
     * @experimental
     */
    readonly minReadySeconds?: number;
    /**
     * @experimental
     */
    readonly paused?: boolean;
    /**
     * @experimental
     */
    readonly progressDeadlineSeconds?: number;
    /**
     * @experimental
     */
    readonly replicas?: number;
    /**
     * @experimental
     */
    readonly revisionHistoryLimit?: number;
    /**
     * @experimental
     */
    readonly selector: k8s.LabelSelector;
    /**
     * @experimental
     */
    readonly template: k8s.PodTemplateSpec;
}
/**
 * @experimental
 */
export interface ArgoRolloutProps {
    /**
     * (experimental) Standard object's metadata.
     *
     * @experimental
     */
    readonly metadata?: k8s.ObjectMeta;
    /**
     * (experimental) Spec defines the behavior of the ingress.
     *
     * @experimental
     */
    readonly spec?: ArgoSpecs;
}
/**
 * @experimental
 */
export declare class ArgoRollout extends ApiObject {
    /**
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for an ingress object. https://github.com/kubernetes-sigs/aws-load-balancer-controller.
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: ArgoRolloutProps): any;
    /**
     * (experimental) Defines an "extentions" API object for AWS Load Balancer Controller - https://github.com/kubernetes-sigs/aws-load-balancer-controller.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ArgoRolloutProps);
}
