# ech-datastructures
Comprehensive package of Python-native datastructures.


![example workflow](https://github.com/rkechols/ech-datastructures/actions/workflows/pylint.yml/badge.svg)
![example workflow](https://github.com/rkechols/ech-datastructures/actions/workflows/pytest.yml/badge.svg)


### Planned Datastructures:
  - tree set (AVL)
  - tree map (AVL)
  - ordered list (?) = binary tree (AVL) with duplicates (counts)
  - trie
  - disjoint set (forest)
  - graph (weighted or not, directed or not, sparse or not)


### Implemented Datastructures:
  - Heap (AKA priority queue)


### Will Not Implement:
  - fixed-size array
  - dynamic array (use `list`)
  - linked list (use `collections.deque`)
  - stack (use `collections.deque`)
  - queue (use `collections.deque`)
  - deque (use `collections.deque`)
  - hash set (use `set`)
  - hash map (use `dict`)


## See Also
  - [Standard Library Time Complexities](https://wiki.python.org/moin/TimeComplexity)
  - [Standard Library `collections`](https://docs.python.org/3/library/collections.html)
