from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ValueSet_IncludeSchema:
    """
    A value set specifies a set of codes drawn from one or more code systems.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A value set specifies a set of codes drawn from one or more code systems.


        system: An absolute URI which is the code system from which the selected codes come
            from.

        version: The version of the code system that the codes are selected from.

        concept: Specifies a concept to be included or excluded.

        filter: Select concepts by specify a matching criteria based on the properties
            (including relationships) defined by the system. If multiple filters are
            specified, they SHALL all be true.

        valueSet: Selects concepts found in this value set. This is an absolute URI that is a
            reference to ValueSet.url.

        """
        from spark_fhir_schemas.stu3.complex_types.valueset_concept import ValueSet_ConceptSchema
        from spark_fhir_schemas.stu3.complex_types.valueset_filter import ValueSet_FilterSchema
        if (
            max_recursion_limit
            and nesting_list.count("ValueSet_Include") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ValueSet_Include"]
        schema = StructType(
            [
                # An absolute URI which is the code system from which the selected codes come
                # from.
                StructField("system", StringType(), True),
                # The version of the code system that the codes are selected from.
                StructField("version", StringType(), True),
                # Specifies a concept to be included or excluded.
                StructField(
                    "concept",
                    ArrayType(
                        ValueSet_ConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Select concepts by specify a matching criteria based on the properties
                # (including relationships) defined by the system. If multiple filters are
                # specified, they SHALL all be true.
                StructField(
                    "filter",
                    ArrayType(
                        ValueSet_FilterSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Selects concepts found in this value set. This is an absolute URI that is a
                # reference to ValueSet.url.
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
