from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ValueSet_ConceptSchema:
    """
    A value set specifies a set of codes drawn from one or more code systems.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A value set specifies a set of codes drawn from one or more code systems.


        code: Specifies a code for the concept to be included or excluded.

        display: The text to display to the user for this concept in the context of this
            valueset. If no display is provided, then applications using the value set use
            the display specified for the code by the system.

        designation: Additional representations for this concept when used in this value set -
            other languages, aliases, specialized purposes, used for particular purposes,
            etc.

        """
        from spark_fhir_schemas.stu3.complex_types.valueset_designation import ValueSet_DesignationSchema
        if (
            max_recursion_limit
            and nesting_list.count("ValueSet_Concept") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ValueSet_Concept"]
        schema = StructType(
            [
                # Specifies a code for the concept to be included or excluded.
                StructField("code", StringType(), True),
                # The text to display to the user for this concept in the context of this
                # valueset. If no display is provided, then applications using the value set use
                # the display specified for the code by the system.
                StructField("display", StringType(), True),
                # Additional representations for this concept when used in this value set -
                # other languages, aliases, specialized purposes, used for particular purposes,
                # etc.
                StructField(
                    "designation",
                    ArrayType(
                        ValueSet_DesignationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
