from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Timing_RepeatSchema:
    """
    Specifies an event that may occur multiple times. Timing schedules are used to
    record when things are planned, expected or requested to occur. The most
    common usage is in dosage instructions for medications. They are also used
    when planning care of various kinds, and may be used for reporting the
    schedule to which past regular activities were carried out.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        Specifies an event that may occur multiple times. Timing schedules are used to
        record when things are planned, expected or requested to occur. The most
        common usage is in dosage instructions for medications. They are also used
        when planning care of various kinds, and may be used for reporting the
        schedule to which past regular activities were carried out.


        boundsDuration: Either a duration for the length of the timing schedule, a range of possible
            length, or outer bounds for start and/or end limits of the timing schedule.

        boundsRange: Either a duration for the length of the timing schedule, a range of possible
            length, or outer bounds for start and/or end limits of the timing schedule.

        boundsPeriod: Either a duration for the length of the timing schedule, a range of possible
            length, or outer bounds for start and/or end limits of the timing schedule.

        count: A total count of the desired number of repetitions.

        countMax: A maximum value for the count of the desired repetitions (e.g. do something
            6-8 times).

        duration: How long this thing happens for when it happens.

        durationMax: The upper limit of how long this thing happens for when it happens.

        durationUnit: The units of time for the duration, in UCUM units.

        frequency: The number of times to repeat the action within the specified period / period
            range (i.e. both period and periodMax provided).

        frequencyMax: If present, indicates that the frequency is a range - so to repeat between
            [frequency] and [frequencyMax] times within the period or period range.

        period: Indicates the duration of time over which repetitions are to occur; e.g. to
            express "3 times per day", 3 would be the frequency and "1 day" would be the
            period.

        periodMax: If present, indicates that the period is a range from [period] to [periodMax],
            allowing expressing concepts such as "do this once every 3-5 days.

        periodUnit: The units of time for the period in UCUM units.

        dayOfWeek: If one or more days of week is provided, then the action happens only on the
            specified day(s).

        timeOfDay: Specified time of day for action to take place.

        when: Real world events that the occurrence of the event should be tied to.

        offset: The number of minutes from the event. If the event code does not indicate
            whether the minutes is before or after the event, then the offset is assumed
            to be after the event.

        """
        from spark_fhir_schemas.stu3.complex_types.duration import DurationSchema
        from spark_fhir_schemas.stu3.complex_types.range import RangeSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        if (
            max_recursion_limit
            and nesting_list.count("Timing_Repeat") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Timing_Repeat"]
        schema = StructType(
            [
                # Either a duration for the length of the timing schedule, a range of possible
                # length, or outer bounds for start and/or end limits of the timing schedule.
                StructField(
                    "boundsDuration",
                    DurationSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Either a duration for the length of the timing schedule, a range of possible
                # length, or outer bounds for start and/or end limits of the timing schedule.
                StructField(
                    "boundsRange",
                    RangeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Either a duration for the length of the timing schedule, a range of possible
                # length, or outer bounds for start and/or end limits of the timing schedule.
                StructField(
                    "boundsPeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # A total count of the desired number of repetitions.
                StructField("count", IntegerType(), True),
                # A maximum value for the count of the desired repetitions (e.g. do something
                # 6-8 times).
                StructField("countMax", IntegerType(), True),
                # How long this thing happens for when it happens.
                StructField("duration", IntegerType(), True),
                # The upper limit of how long this thing happens for when it happens.
                StructField("durationMax", IntegerType(), True),
                # The units of time for the duration, in UCUM units.
                StructField("durationUnit", StringType(), True),
                # The number of times to repeat the action within the specified period / period
                # range (i.e. both period and periodMax provided).
                StructField("frequency", IntegerType(), True),
                # If present, indicates that the frequency is a range - so to repeat between
                # [frequency] and [frequencyMax] times within the period or period range.
                StructField("frequencyMax", IntegerType(), True),
                # Indicates the duration of time over which repetitions are to occur; e.g. to
                # express "3 times per day", 3 would be the frequency and "1 day" would be the
                # period.
                StructField("period", IntegerType(), True),
                # If present, indicates that the period is a range from [period] to [periodMax],
                # allowing expressing concepts such as "do this once every 3-5 days.
                StructField("periodMax", IntegerType(), True),
                # The units of time for the period in UCUM units.
                StructField("periodUnit", StringType(), True),
                # If one or more days of week is provided, then the action happens only on the
                # specified day(s).
                # Specified time of day for action to take place.
                # Real world events that the occurrence of the event should be tied to.
                # The number of minutes from the event. If the event code does not indicate
                # whether the minutes is before or after the event, then the offset is assumed
                # to be after the event.
                StructField("offset", IntegerType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
