from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class TestScript_CapabilitySchema:
    """
    A structured set of tests against a FHIR server implementation to determine
    compliance against the FHIR specification.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A structured set of tests against a FHIR server implementation to determine
        compliance against the FHIR specification.


        required: Whether or not the test execution will require the given capabilities of the
            server in order for this test script to execute.

        validated: Whether or not the test execution will validate the given capabilities of the
            server in order for this test script to execute.

        description: Description of the capabilities that this test script is requiring the server
            to support.

        origin: Which origin server these requirements apply to.

        destination: Which server these requirements apply to.

        link: Links to the FHIR specification that describes this interaction and the
            resources involved in more detail.

        capabilities: Minimum capabilities required of server for test script to execute
            successfully.   If server does not meet at a minimum the referenced capability
            statement, then all tests in this script are skipped.

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        if (
            max_recursion_limit and
            nesting_list.count("TestScript_Capability") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["TestScript_Capability"]
        schema = StructType(
            [
                # Whether or not the test execution will require the given capabilities of the
                # server in order for this test script to execute.
                StructField("required", BooleanType(), True),
                # Whether or not the test execution will validate the given capabilities of the
                # server in order for this test script to execute.
                StructField("validated", BooleanType(), True),
                # Description of the capabilities that this test script is requiring the server
                # to support.
                StructField("description", StringType(), True),
                # Which origin server these requirements apply to.
                # Which server these requirements apply to.
                StructField("destination", IntegerType(), True),
                # Links to the FHIR specification that describes this interaction and the
                # resources involved in more detail.
                # Minimum capabilities required of server for test script to execute
                # successfully.   If server does not meet at a minimum the referenced capability
                # statement, then all tests in this script are skipped.
                StructField(
                    "capabilities",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
