from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class SubstanceSchema:
    """
    A homogeneous material with a definite composition.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A homogeneous material with a definite composition.


        resourceType: This is a Substance resource

        identifier: Unique identifier for the substance.

        status: A code to indicate if the substance is actively used.

        category: A code that classifies the general type of substance.  This is used  for
            searching, sorting and display purposes.

        code: A code (or set of codes) that identify this substance.

        description: A description of the substance - its appearance, handling requirements, and
            other usage notes.

        instance: Substance may be used to describe a kind of substance, or a specific
            package/container of the substance: an instance.

        ingredient: A substance can be composed of other substances.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.substance_instance import Substance_InstanceSchema
        from spark_fhir_schemas.stu3.complex_types.substance_ingredient import Substance_IngredientSchema
        if (
            max_recursion_limit
            and nesting_list.count("Substance") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Substance"]
        schema = StructType(
            [
                # This is a Substance resource
                StructField("resourceType", StringType(), True),
                # Unique identifier for the substance.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A code to indicate if the substance is actively used.
                StructField("status", StringType(), True),
                # A code that classifies the general type of substance.  This is used  for
                # searching, sorting and display purposes.
                StructField(
                    "category",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A code (or set of codes) that identify this substance.
                StructField(
                    "code",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # A description of the substance - its appearance, handling requirements, and
                # other usage notes.
                StructField("description", StringType(), True),
                # Substance may be used to describe a kind of substance, or a specific
                # package/container of the substance: an instance.
                StructField(
                    "instance",
                    ArrayType(
                        Substance_InstanceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A substance can be composed of other substances.
                StructField(
                    "ingredient",
                    ArrayType(
                        Substance_IngredientSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
