from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class StructureMap_TargetSchema:
    """
    A Map of relationships between 2 structures that can be used to transform
    data.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A Map of relationships between 2 structures that can be used to transform
        data.


        context: Type or variable this rule applies to.

        contextType: How to interpret the context.

        element: Field to create in the context.

        variable: Named context for field, if desired, and a field is specified.

        listMode: If field is a list, how to manage the list.

        listRuleId: Internal rule reference for shared list items.

        transform: How the data is copied / created.

        parameter: Parameters to the transform.

        """
        from spark_fhir_schemas.stu3.complex_types.structuremap_parameter import StructureMap_ParameterSchema
        if (
            max_recursion_limit and
            nesting_list.count("StructureMap_Target") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["StructureMap_Target"]
        schema = StructType(
            [
                # Type or variable this rule applies to.
                StructField("context", StringType(), True),
                # How to interpret the context.
                StructField("contextType", StringType(), True),
                # Field to create in the context.
                StructField("element", StringType(), True),
                # Named context for field, if desired, and a field is specified.
                StructField("variable", StringType(), True),
                # If field is a list, how to manage the list.
                # Internal rule reference for shared list items.
                StructField("listRuleId", StringType(), True),
                # How the data is copied / created.
                StructField("transform", StringType(), True),
                # Parameters to the transform.
                StructField(
                    "parameter",
                    ArrayType(
                        StructureMap_ParameterSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
