from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class StructureMap_GroupSchema:
    """
    A Map of relationships between 2 structures that can be used to transform
    data.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A Map of relationships between 2 structures that can be used to transform
        data.


        name: A unique name for the group for the convenience of human readers.

        extends: Another group that this group adds rules to.

        typeMode: If this is the default rule set to apply for thie source type, or this
            combination of types.

        documentation: Additional supporting documentation that explains the purpose of the group and
            the types of mappings within it.

        input: A name assigned to an instance of data. The instance must be provided when the
            mapping is invoked.

        rule: Transform Rule from source to target.

        """
        from spark_fhir_schemas.stu3.complex_types.structuremap_input import StructureMap_InputSchema
        from spark_fhir_schemas.stu3.complex_types.structuremap_rule import StructureMap_RuleSchema
        if (
            max_recursion_limit
            and nesting_list.count("StructureMap_Group") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["StructureMap_Group"]
        schema = StructType(
            [
                # A unique name for the group for the convenience of human readers.
                StructField("name", StringType(), True),
                # Another group that this group adds rules to.
                StructField("extends", StringType(), True),
                # If this is the default rule set to apply for thie source type, or this
                # combination of types.
                StructField("typeMode", StringType(), True),
                # Additional supporting documentation that explains the purpose of the group and
                # the types of mappings within it.
                StructField("documentation", StringType(), True),
                # A name assigned to an instance of data. The instance must be provided when the
                # mapping is invoked.
                StructField(
                    "input",
                    ArrayType(
                        StructureMap_InputSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Transform Rule from source to target.
                StructField(
                    "rule",
                    ArrayType(
                        StructureMap_RuleSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
