from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ServiceDefinitionSchema:
    """
    The ServiceDefinition describes a unit of decision support functionality that
    is made available as a service, such as immunization modules or drug-drug
    interaction checking.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        The ServiceDefinition describes a unit of decision support functionality that
        is made available as a service, such as immunization modules or drug-drug
        interaction checking.


        resourceType: This is a ServiceDefinition resource

        url: An absolute URI that is used to identify this service definition when it is
            referenced in a specification, model, design or an instance. This SHALL be a
            URL, SHOULD be globally unique, and SHOULD be an address at which this service
            definition is (or will be) published. The URL SHOULD include the major version
            of the service definition. For more information see [Technical and Business
            Versions](resource.html#versions).

        identifier: A formal identifier that is used to identify this service definition when it
            is represented in other formats, or referenced in a specification, model,
            design or an instance. This is used for CMS or NQF identifiers for a measure
            artifact. Note that at least one identifier is required for non-experimental
            active artifacts.

        version: The identifier that is used to identify this version of the service definition
            when it is referenced in a specification, model, design or instance. This is
            an arbitrary value managed by the service definition author and is not
            expected to be globally unique. For example, it might be a timestamp (e.g.
            yyyymmdd) if a managed version is not available. There is also no expectation
            that versions can be placed in a lexicographical sequence.

        name: A natural language name identifying the service definition. This name should
            be usable as an identifier for the module by machine processing applications
            such as code generation.

        title: A short, descriptive, user-friendly title for the service definition.

        status: The status of this service definition. Enables tracking the life-cycle of the
            content.

        experimental: A boolean value to indicate that this service definition is authored for
            testing purposes (or education/evaluation/marketing), and is not intended to
            be used for genuine usage.

        date: The date  (and optionally time) when the service definition was published. The
            date must change if and when the business version changes and it must change
            if the status code changes. In addition, it should change when the substantive
            content of the service definition changes.

        publisher: The name of the individual or organization that published the service
            definition.

        description: A free text natural language description of the service definition from a
            consumer's perspective.

        purpose: Explaination of why this service definition is needed and why it has been
            designed as it has.

        usage: A detailed description of how the module is used from a clinical perspective.

        approvalDate: The date on which the resource content was approved by the publisher. Approval
            happens once when the content is officially approved for usage.

        lastReviewDate: The date on which the resource content was last reviewed. Review happens
            periodically after approval, but doesn't change the original approval date.

        effectivePeriod: The period during which the service definition content was or is planned to be
            in active use.

        useContext: The content was developed with a focus and intent of supporting the contexts
            that are listed. These terms may be used to assist with indexing and searching
            for appropriate service definition instances.

        jurisdiction: A legal or geographic region in which the service definition is intended to be
            used.

        topic: Descriptive topics related to the module. Topics provide a high-level
            categorization of the module that can be useful for filtering and searching.

        contributor: A contributor to the content of the module, including authors, editors,
            reviewers, and endorsers.

        contact: Contact details to assist a user in finding and communicating with the
            publisher.

        copyright: A copyright statement relating to the service definition and/or its contents.
            Copyright statements are generally legal restrictions on the use and
            publishing of the service definition.

        relatedArtifact: Related resources such as additional documentation, justification, or
            bibliographic references.

        trigger: The trigger element defines when the rule should be invoked. This information
            is used by consumers of the rule to determine how to integrate the rule into a
            specific workflow.

        dataRequirement: Data requirements are a machine processable description of the data required
            by the module in order to perform a successful evaluation.

        operationDefinition: A reference to the operation that is used to invoke this service.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.usagecontext import UsageContextSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.contributor import ContributorSchema
        from spark_fhir_schemas.stu3.complex_types.contactdetail import ContactDetailSchema
        from spark_fhir_schemas.stu3.complex_types.relatedartifact import RelatedArtifactSchema
        from spark_fhir_schemas.stu3.complex_types.triggerdefinition import TriggerDefinitionSchema
        from spark_fhir_schemas.stu3.complex_types.datarequirement import DataRequirementSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        if (
            max_recursion_limit
            and nesting_list.count("ServiceDefinition") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ServiceDefinition"]
        schema = StructType(
            [
                # This is a ServiceDefinition resource
                StructField("resourceType", StringType(), True),
                # An absolute URI that is used to identify this service definition when it is
                # referenced in a specification, model, design or an instance. This SHALL be a
                # URL, SHOULD be globally unique, and SHOULD be an address at which this service
                # definition is (or will be) published. The URL SHOULD include the major version
                # of the service definition. For more information see [Technical and Business
                # Versions](resource.html#versions).
                StructField("url", StringType(), True),
                # A formal identifier that is used to identify this service definition when it
                # is represented in other formats, or referenced in a specification, model,
                # design or an instance. This is used for CMS or NQF identifiers for a measure
                # artifact. Note that at least one identifier is required for non-experimental
                # active artifacts.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The identifier that is used to identify this version of the service definition
                # when it is referenced in a specification, model, design or instance. This is
                # an arbitrary value managed by the service definition author and is not
                # expected to be globally unique. For example, it might be a timestamp (e.g.
                # yyyymmdd) if a managed version is not available. There is also no expectation
                # that versions can be placed in a lexicographical sequence.
                StructField("version", StringType(), True),
                # A natural language name identifying the service definition. This name should
                # be usable as an identifier for the module by machine processing applications
                # such as code generation.
                StructField("name", StringType(), True),
                # A short, descriptive, user-friendly title for the service definition.
                StructField("title", StringType(), True),
                # The status of this service definition. Enables tracking the life-cycle of the
                # content.
                StructField("status", StringType(), True),
                # A boolean value to indicate that this service definition is authored for
                # testing purposes (or education/evaluation/marketing), and is not intended to
                # be used for genuine usage.
                StructField("experimental", BooleanType(), True),
                # The date  (and optionally time) when the service definition was published. The
                # date must change if and when the business version changes and it must change
                # if the status code changes. In addition, it should change when the substantive
                # content of the service definition changes.
                StructField("date", StringType(), True),
                # The name of the individual or organization that published the service
                # definition.
                StructField("publisher", StringType(), True),
                # A free text natural language description of the service definition from a
                # consumer's perspective.
                StructField("description", StringType(), True),
                # Explaination of why this service definition is needed and why it has been
                # designed as it has.
                StructField("purpose", StringType(), True),
                # A detailed description of how the module is used from a clinical perspective.
                StructField("usage", StringType(), True),
                # The date on which the resource content was approved by the publisher. Approval
                # happens once when the content is officially approved for usage.
                StructField("approvalDate", StringType(), True),
                # The date on which the resource content was last reviewed. Review happens
                # periodically after approval, but doesn't change the original approval date.
                StructField("lastReviewDate", StringType(), True),
                # The period during which the service definition content was or is planned to be
                # in active use.
                StructField(
                    "effectivePeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The content was developed with a focus and intent of supporting the contexts
                # that are listed. These terms may be used to assist with indexing and searching
                # for appropriate service definition instances.
                StructField(
                    "useContext",
                    ArrayType(
                        UsageContextSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A legal or geographic region in which the service definition is intended to be
                # used.
                StructField(
                    "jurisdiction",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Descriptive topics related to the module. Topics provide a high-level
                # categorization of the module that can be useful for filtering and searching.
                StructField(
                    "topic",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A contributor to the content of the module, including authors, editors,
                # reviewers, and endorsers.
                StructField(
                    "contributor",
                    ArrayType(
                        ContributorSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Contact details to assist a user in finding and communicating with the
                # publisher.
                StructField(
                    "contact",
                    ArrayType(
                        ContactDetailSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A copyright statement relating to the service definition and/or its contents.
                # Copyright statements are generally legal restrictions on the use and
                # publishing of the service definition.
                StructField("copyright", StringType(), True),
                # Related resources such as additional documentation, justification, or
                # bibliographic references.
                StructField(
                    "relatedArtifact",
                    ArrayType(
                        RelatedArtifactSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The trigger element defines when the rule should be invoked. This information
                # is used by consumers of the rule to determine how to integrate the rule into a
                # specific workflow.
                StructField(
                    "trigger",
                    ArrayType(
                        TriggerDefinitionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Data requirements are a machine processable description of the data required
                # by the module in order to perform a successful evaluation.
                StructField(
                    "dataRequirement",
                    ArrayType(
                        DataRequirementSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A reference to the operation that is used to invoke this service.
                StructField(
                    "operationDefinition",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
