from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class RelatedArtifactSchema:
    """
    Related artifacts such as additional documentation, justification, or
    bibliographic references.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        Related artifacts such as additional documentation, justification, or
        bibliographic references.


        type: The type of relationship to the related artifact.

        display: A brief description of the document or knowledge resource being referenced,
            suitable for display to a consumer.

        citation: A bibliographic citation for the related artifact. This text SHOULD be
            formatted according to an accepted citation format.

        url: A url for the artifact that can be followed to access the actual content.

        document: The document being referenced, represented as an attachment. This is exclusive
            with the resource element.

        resource: The related resource, such as a library, value set, profile, or other
            knowledge resource.

        """
        from spark_fhir_schemas.stu3.complex_types.attachment import AttachmentSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        if (
            max_recursion_limit
            and nesting_list.count("RelatedArtifact") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["RelatedArtifact"]
        schema = StructType(
            [
                # The type of relationship to the related artifact.
                StructField("type", StringType(), True),
                # A brief description of the document or knowledge resource being referenced,
                # suitable for display to a consumer.
                StructField("display", StringType(), True),
                # A bibliographic citation for the related artifact. This text SHOULD be
                # formatted according to an accepted citation format.
                StructField("citation", StringType(), True),
                # A url for the artifact that can be followed to access the actual content.
                StructField("url", StringType(), True),
                # The document being referenced, represented as an attachment. This is exclusive
                # with the resource element.
                StructField(
                    "document",
                    AttachmentSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The related resource, such as a library, value set, profile, or other
                # knowledge resource.
                StructField(
                    "resource",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
