from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Provenance_EntitySchema:
    """
    Provenance of a resource is a record that describes entities and processes
    involved in producing and delivering or otherwise influencing that resource.
    Provenance provides a critical foundation for assessing authenticity, enabling
    trust, and allowing reproducibility. Provenance assertions are a form of
    contextual metadata and can themselves become important records with their own
    provenance. Provenance statement indicates clinical significance in terms of
    confidence in authenticity, reliability, and trustworthiness, integrity, and
    stage in lifecycle (e.g. Document Completion - has the artifact been legally
    authenticated), all of which may impact security, privacy, and trust policies.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        Provenance of a resource is a record that describes entities and processes
        involved in producing and delivering or otherwise influencing that resource.
        Provenance provides a critical foundation for assessing authenticity, enabling
        trust, and allowing reproducibility. Provenance assertions are a form of
        contextual metadata and can themselves become important records with their own
        provenance. Provenance statement indicates clinical significance in terms of
        confidence in authenticity, reliability, and trustworthiness, integrity, and
        stage in lifecycle (e.g. Document Completion - has the artifact been legally
        authenticated), all of which may impact security, privacy, and trust policies.


        role: How the entity was used during the activity.

        whatUri: Identity of the  Entity used. May be a logical or physical uri and maybe
            absolute or relative.

        whatReference: Identity of the  Entity used. May be a logical or physical uri and maybe
            absolute or relative.

        whatIdentifier: Identity of the  Entity used. May be a logical or physical uri and maybe
            absolute or relative.

        agent: The entity is attributed to an agent to express the agent's responsibility for
            that entity, possibly along with other agents. This description can be
            understood as shorthand for saying that the agent was responsible for the
            activity which generated the entity.

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.provenance_agent import Provenance_AgentSchema
        if (
            max_recursion_limit
            and nesting_list.count("Provenance_Entity") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Provenance_Entity"]
        schema = StructType(
            [
                # How the entity was used during the activity.
                StructField("role", StringType(), True),
                # Identity of the  Entity used. May be a logical or physical uri and maybe
                # absolute or relative.
                StructField("whatUri", StringType(), True),
                # Identity of the  Entity used. May be a logical or physical uri and maybe
                # absolute or relative.
                StructField(
                    "whatReference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Identity of the  Entity used. May be a logical or physical uri and maybe
                # absolute or relative.
                StructField(
                    "whatIdentifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The entity is attributed to an agent to express the agent's responsibility for
                # that entity, possibly along with other agents. This description can be
                # understood as shorthand for saying that the agent was responsible for the
                # activity which generated the entity.
                StructField(
                    "agent",
                    ArrayType(
                        Provenance_AgentSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
