from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ProcedureSchema:
    """
    An action that is or was performed on a patient. This can be a physical
    intervention like an operation, or less invasive like counseling or
    hypnotherapy.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        An action that is or was performed on a patient. This can be a physical
        intervention like an operation, or less invasive like counseling or
        hypnotherapy.


        resourceType: This is a Procedure resource

        identifier: This records identifiers associated with this procedure that are defined by
            business processes and/or used to refer to it when a direct URL reference to
            the resource itself is not appropriate (e.g. in CDA documents, or in written /
            printed documentation).

        definition: A protocol, guideline, orderset or other definition that was adhered to in
            whole or in part by this procedure.

        basedOn: A reference to a resource that contains details of the request for this
            procedure.

        partOf: A larger event of which this particular procedure is a component or step.

        status: A code specifying the state of the procedure. Generally this will be in-
            progress or completed state.

        notDone: Set this to true if the record is saying that the procedure was NOT performed.

        notDoneReason: A code indicating why the procedure was not performed.

        category: A code that classifies the procedure for searching, sorting and display
            purposes (e.g. "Surgical Procedure").

        code: The specific procedure that is performed. Use text if the exact nature of the
            procedure cannot be coded (e.g. "Laparoscopic Appendectomy").

        subject: The person, animal or group on which the procedure was performed.

        context: The encounter during which the procedure was performed.

        performedDateTime: The date(time)/period over which the procedure was performed. Allows a period
            to support complex procedures that span more than one date, and also allows
            for the length of the procedure to be captured.

        performedPeriod: The date(time)/period over which the procedure was performed. Allows a period
            to support complex procedures that span more than one date, and also allows
            for the length of the procedure to be captured.

        performer: Limited to 'real' people rather than equipment.

        location: The location where the procedure actually happened.  E.g. a newborn at home, a
            tracheostomy at a restaurant.

        reasonCode: The coded reason why the procedure was performed. This may be coded entity of
            some type, or may simply be present as text.

        reasonReference: The condition that is the reason why the procedure was performed.

        bodySite: Detailed and structured anatomical location information. Multiple locations
            are allowed - e.g. multiple punch biopsies of a lesion.

        outcome: The outcome of the procedure - did it resolve reasons for the procedure being
            performed?

        report: This could be a histology result, pathology report, surgical report, etc..

        complication: Any complications that occurred during the procedure, or in the immediate
            post-performance period. These are generally tracked separately from the
            notes, which will typically describe the procedure itself rather than any
            'post procedure' issues.

        complicationDetail: Any complications that occurred during the procedure, or in the immediate
            post-performance period.

        followUp: If the procedure required specific follow up - e.g. removal of sutures. The
            followup may be represented as a simple note, or could potentially be more
            complex in which case the CarePlan resource can be used.

        note: Any other notes about the procedure.  E.g. the operative notes.

        focalDevice: A device that is implanted, removed or otherwise manipulated (calibration,
            battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a
            focal portion of the Procedure.

        usedReference: Identifies medications, devices and any other substance used as part of the
            procedure.

        usedCode: Identifies coded items that were used as part of the procedure.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.procedure_performer import Procedure_PerformerSchema
        from spark_fhir_schemas.stu3.complex_types.annotation import AnnotationSchema
        from spark_fhir_schemas.stu3.complex_types.procedure_focaldevice import Procedure_FocalDeviceSchema
        if (
            max_recursion_limit
            and nesting_list.count("Procedure") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Procedure"]
        schema = StructType(
            [
                # This is a Procedure resource
                StructField("resourceType", StringType(), True),
                # This records identifiers associated with this procedure that are defined by
                # business processes and/or used to refer to it when a direct URL reference to
                # the resource itself is not appropriate (e.g. in CDA documents, or in written /
                # printed documentation).
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A protocol, guideline, orderset or other definition that was adhered to in
                # whole or in part by this procedure.
                StructField(
                    "definition",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A reference to a resource that contains details of the request for this
                # procedure.
                StructField(
                    "basedOn",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A larger event of which this particular procedure is a component or step.
                StructField(
                    "partOf",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A code specifying the state of the procedure. Generally this will be in-
                # progress or completed state.
                StructField("status", StringType(), True),
                # Set this to true if the record is saying that the procedure was NOT performed.
                StructField("notDone", BooleanType(), True),
                # A code indicating why the procedure was not performed.
                StructField(
                    "notDoneReason",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # A code that classifies the procedure for searching, sorting and display
                # purposes (e.g. "Surgical Procedure").
                StructField(
                    "category",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The specific procedure that is performed. Use text if the exact nature of the
                # procedure cannot be coded (e.g. "Laparoscopic Appendectomy").
                StructField(
                    "code",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The person, animal or group on which the procedure was performed.
                StructField(
                    "subject",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The encounter during which the procedure was performed.
                StructField(
                    "context",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The date(time)/period over which the procedure was performed. Allows a period
                # to support complex procedures that span more than one date, and also allows
                # for the length of the procedure to be captured.
                StructField("performedDateTime", StringType(), True),
                # The date(time)/period over which the procedure was performed. Allows a period
                # to support complex procedures that span more than one date, and also allows
                # for the length of the procedure to be captured.
                StructField(
                    "performedPeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Limited to 'real' people rather than equipment.
                StructField(
                    "performer",
                    ArrayType(
                        Procedure_PerformerSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The location where the procedure actually happened.  E.g. a newborn at home, a
                # tracheostomy at a restaurant.
                StructField(
                    "location",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The coded reason why the procedure was performed. This may be coded entity of
                # some type, or may simply be present as text.
                StructField(
                    "reasonCode",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The condition that is the reason why the procedure was performed.
                StructField(
                    "reasonReference",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Detailed and structured anatomical location information. Multiple locations
                # are allowed - e.g. multiple punch biopsies of a lesion.
                StructField(
                    "bodySite",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The outcome of the procedure - did it resolve reasons for the procedure being
                # performed?
                StructField(
                    "outcome",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # This could be a histology result, pathology report, surgical report, etc..
                StructField(
                    "report",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Any complications that occurred during the procedure, or in the immediate
                # post-performance period. These are generally tracked separately from the
                # notes, which will typically describe the procedure itself rather than any
                # 'post procedure' issues.
                StructField(
                    "complication",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Any complications that occurred during the procedure, or in the immediate
                # post-performance period.
                StructField(
                    "complicationDetail",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # If the procedure required specific follow up - e.g. removal of sutures. The
                # followup may be represented as a simple note, or could potentially be more
                # complex in which case the CarePlan resource can be used.
                StructField(
                    "followUp",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Any other notes about the procedure.  E.g. the operative notes.
                StructField(
                    "note",
                    ArrayType(
                        AnnotationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A device that is implanted, removed or otherwise manipulated (calibration,
                # battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a
                # focal portion of the Procedure.
                StructField(
                    "focalDevice",
                    ArrayType(
                        Procedure_FocalDeviceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Identifies medications, devices and any other substance used as part of the
                # procedure.
                StructField(
                    "usedReference",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Identifies coded items that were used as part of the procedure.
                StructField(
                    "usedCode",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
