from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class NamingSystemSchema:
    """
    A curated namespace that issues unique symbols within that namespace for the
    identification of concepts, people, devices, etc.  Represents a "System" used
    within the Identifier and Coding data types.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A curated namespace that issues unique symbols within that namespace for the
        identification of concepts, people, devices, etc.  Represents a "System" used
        within the Identifier and Coding data types.


        resourceType: This is a NamingSystem resource

        name: A natural language name identifying the naming system. This name should be
            usable as an identifier for the module by machine processing applications such
            as code generation.

        status: The status of this naming system. Enables tracking the life-cycle of the
            content.

        kind: Indicates the purpose for the naming system - what kinds of things does it
            make unique?

        date: The date  (and optionally time) when the naming system was published. The date
            must change if and when the business version changes and it must change if the
            status code changes. In addition, it should change when the substantive
            content of the naming system changes.

        publisher: The name of the individual or organization that published the naming system.

        contact: Contact details to assist a user in finding and communicating with the
            publisher.

        responsible: The name of the organization that is responsible for issuing identifiers or
            codes for this namespace and ensuring their non-collision.

        type: Categorizes a naming system for easier search by grouping related naming
            systems.

        description: A free text natural language description of the naming system from a
            consumer's perspective. Details about what the namespace identifies including
            scope, granularity, version labeling, etc.

        useContext: The content was developed with a focus and intent of supporting the contexts
            that are listed. These terms may be used to assist with indexing and searching
            for appropriate naming system instances.

        jurisdiction: A legal or geographic region in which the naming system is intended to be
            used.

        usage: Provides guidance on the use of the namespace, including the handling of
            formatting characters, use of upper vs. lower case, etc.

        uniqueId: Indicates how the system may be identified when referenced in electronic
            exchange.

        replacedBy: For naming systems that are retired, indicates the naming system that should
            be used in their place (if any).

        """
        from spark_fhir_schemas.stu3.complex_types.contactdetail import ContactDetailSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.usagecontext import UsageContextSchema
        from spark_fhir_schemas.stu3.complex_types.namingsystem_uniqueid import NamingSystem_UniqueIdSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        if (
            max_recursion_limit
            and nesting_list.count("NamingSystem") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["NamingSystem"]
        schema = StructType(
            [
                # This is a NamingSystem resource
                StructField("resourceType", StringType(), True),
                # A natural language name identifying the naming system. This name should be
                # usable as an identifier for the module by machine processing applications such
                # as code generation.
                StructField("name", StringType(), True),
                # The status of this naming system. Enables tracking the life-cycle of the
                # content.
                StructField("status", StringType(), True),
                # Indicates the purpose for the naming system - what kinds of things does it
                # make unique?
                StructField("kind", StringType(), True),
                # The date  (and optionally time) when the naming system was published. The date
                # must change if and when the business version changes and it must change if the
                # status code changes. In addition, it should change when the substantive
                # content of the naming system changes.
                StructField("date", StringType(), True),
                # The name of the individual or organization that published the naming system.
                StructField("publisher", StringType(), True),
                # Contact details to assist a user in finding and communicating with the
                # publisher.
                StructField(
                    "contact",
                    ArrayType(
                        ContactDetailSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The name of the organization that is responsible for issuing identifiers or
                # codes for this namespace and ensuring their non-collision.
                StructField("responsible", StringType(), True),
                # Categorizes a naming system for easier search by grouping related naming
                # systems.
                StructField(
                    "type",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # A free text natural language description of the naming system from a
                # consumer's perspective. Details about what the namespace identifies including
                # scope, granularity, version labeling, etc.
                StructField("description", StringType(), True),
                # The content was developed with a focus and intent of supporting the contexts
                # that are listed. These terms may be used to assist with indexing and searching
                # for appropriate naming system instances.
                StructField(
                    "useContext",
                    ArrayType(
                        UsageContextSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A legal or geographic region in which the naming system is intended to be
                # used.
                StructField(
                    "jurisdiction",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Provides guidance on the use of the namespace, including the handling of
                # formatting characters, use of upper vs. lower case, etc.
                StructField("usage", StringType(), True),
                # Indicates how the system may be identified when referenced in electronic
                # exchange.
                StructField(
                    "uniqueId",
                    ArrayType(
                        NamingSystem_UniqueIdSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # For naming systems that are retired, indicates the naming system that should
                # be used in their place (if any).
                StructField(
                    "replacedBy",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
