from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class MetaSchema:
    """
    The metadata about a resource. This is content in the resource that is
    maintained by the infrastructure. Changes to the content may not always be
    associated with version changes to the resource.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        The metadata about a resource. This is content in the resource that is
        maintained by the infrastructure. Changes to the content may not always be
        associated with version changes to the resource.


        versionId: The version specific identifier, as it appears in the version portion of the
            URL. This values changes when the resource is created, updated, or deleted.

        lastUpdated: When the resource last changed - e.g. when the version changed.

        profile: A list of profiles (references to [[[StructureDefinition]]] resources) that
            this resource claims to conform to. The URL is a reference to
            [[[StructureDefinition.url]]].

        security: Security labels applied to this resource. These tags connect specific
            resources to the overall security policy and infrastructure.

        tag: Tags applied to this resource. Tags are intended to be used to identify and
            relate resources to process and workflow, and applications are not required to
            consider the tags when interpreting the meaning of a resource.

        """
        from spark_fhir_schemas.stu3.complex_types.coding import CodingSchema
        if (
            max_recursion_limit
            and nesting_list.count("Meta") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Meta"]
        schema = StructType(
            [
                # The version specific identifier, as it appears in the version portion of the
                # URL. This values changes when the resource is created, updated, or deleted.
                StructField("versionId", StringType(), True),
                # When the resource last changed - e.g. when the version changed.
                StructField("lastUpdated", StringType(), True),
                # A list of profiles (references to [[[StructureDefinition]]] resources) that
                # this resource claims to conform to. The URL is a reference to
                # [[[StructureDefinition.url]]].
                # Security labels applied to this resource. These tags connect specific
                # resources to the overall security policy and infrastructure.
                StructField(
                    "security",
                    ArrayType(
                        CodingSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Tags applied to this resource. Tags are intended to be used to identify and
                # relate resources to process and workflow, and applications are not required to
                # consider the tags when interpreting the meaning of a resource.
                StructField(
                    "tag",
                    ArrayType(
                        CodingSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
