from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class MessageHeaderSchema:
    """
    The header for a message exchange that is either requesting or responding to
    an action.  The reference(s) that are the subject of the action as well as
    other information related to the action are typically transmitted in a bundle
    in which the MessageHeader resource instance is the first resource in the
    bundle.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        The header for a message exchange that is either requesting or responding to
        an action.  The reference(s) that are the subject of the action as well as
        other information related to the action are typically transmitted in a bundle
        in which the MessageHeader resource instance is the first resource in the
        bundle.


        resourceType: This is a MessageHeader resource

        event: Code that identifies the event this message represents and connects it with
            its definition. Events defined as part of the FHIR specification have the
            system value "http://hl7.org/fhir/message-events".

        destination: The destination application which the message is intended for.

        receiver: Allows data conveyed by a message to be addressed to a particular person or
            department when routing to a specific application isn't sufficient.

        sender: Identifies the sending system to allow the use of a trust relationship.

        timestamp: The time that the message was sent.

        enterer: The person or device that performed the data entry leading to this message.
            When there is more than one candidate, pick the most proximal to the message.
            Can provide other enterers in extensions.

        author: The logical author of the message - the person or device that decided the
            described event should happen. When there is more than one candidate, pick the
            most proximal to the MessageHeader. Can provide other authors in extensions.

        source: The source application from which this message originated.

        responsible: The person or organization that accepts overall responsibility for the
            contents of the message. The implication is that the message event happened
            under the policies of the responsible party.

        reason: Coded indication of the cause for the event - indicates  a reason for the
            occurrence of the event that is a focus of this message.

        response: Information about the message that this message is a response to.  Only
            present if this message is a response.

        focus: The actual data of the message - a reference to the root/focus class of the
            event.

        """
        from spark_fhir_schemas.stu3.complex_types.coding import CodingSchema
        from spark_fhir_schemas.stu3.complex_types.messageheader_destination import MessageHeader_DestinationSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.messageheader_source import MessageHeader_SourceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.messageheader_response import MessageHeader_ResponseSchema
        if (
            max_recursion_limit
            and nesting_list.count("MessageHeader") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["MessageHeader"]
        schema = StructType(
            [
                # This is a MessageHeader resource
                StructField("resourceType", StringType(), True),
                # Code that identifies the event this message represents and connects it with
                # its definition. Events defined as part of the FHIR specification have the
                # system value "http://hl7.org/fhir/message-events".
                StructField(
                    "event",
                    CodingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The destination application which the message is intended for.
                StructField(
                    "destination",
                    ArrayType(
                        MessageHeader_DestinationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Allows data conveyed by a message to be addressed to a particular person or
                # department when routing to a specific application isn't sufficient.
                StructField(
                    "receiver",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Identifies the sending system to allow the use of a trust relationship.
                StructField(
                    "sender",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The time that the message was sent.
                StructField("timestamp", StringType(), True),
                # The person or device that performed the data entry leading to this message.
                # When there is more than one candidate, pick the most proximal to the message.
                # Can provide other enterers in extensions.
                StructField(
                    "enterer",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The logical author of the message - the person or device that decided the
                # described event should happen. When there is more than one candidate, pick the
                # most proximal to the MessageHeader. Can provide other authors in extensions.
                StructField(
                    "author",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The source application from which this message originated.
                StructField(
                    "source",
                    MessageHeader_SourceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The person or organization that accepts overall responsibility for the
                # contents of the message. The implication is that the message event happened
                # under the policies of the responsible party.
                StructField(
                    "responsible",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Coded indication of the cause for the event - indicates  a reason for the
                # occurrence of the event that is a focus of this message.
                StructField(
                    "reason",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Information about the message that this message is a response to.  Only
                # present if this message is a response.
                StructField(
                    "response",
                    MessageHeader_ResponseSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The actual data of the message - a reference to the root/focus class of the
                # event.
                StructField(
                    "focus",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
