from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class MedicationDispense_PerformerSchema:
    """
    Indicates that a medication product is to be or has been dispensed for a named
    person/patient.  This includes a description of the medication product
    (supply) provided and the instructions for administering the medication.  The
    medication dispense is the result of a pharmacy system responding to a
    medication order.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        Indicates that a medication product is to be or has been dispensed for a named
        person/patient.  This includes a description of the medication product
        (supply) provided and the instructions for administering the medication.  The
        medication dispense is the result of a pharmacy system responding to a
        medication order.


        actor: The device, practitioner, etc. who performed the action.  It should be assumed
            that the actor is the dispenser of the medication.

        onBehalfOf: The organization the device or practitioner was acting on behalf of.

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        if (
            max_recursion_limit
            and nesting_list.count("MedicationDispense_Performer") >=
            max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + [
            "MedicationDispense_Performer"
        ]
        schema = StructType(
            [
                # The device, practitioner, etc. who performed the action.  It should be assumed
                # that the actor is the dispenser of the medication.
                StructField(
                    "actor",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The organization the device or practitioner was acting on behalf of.
                StructField(
                    "onBehalfOf",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
