from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class MediaSchema:
    """
    A photo, video, or audio recording acquired or used in healthcare. The actual
    content may be inline or provided by direct reference.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A photo, video, or audio recording acquired or used in healthcare. The actual
        content may be inline or provided by direct reference.


        resourceType: This is a Media resource

        identifier: Identifiers associated with the image - these may include identifiers for the
            image itself, identifiers for the context of its collection (e.g. series ids)
            and context ids such as accession numbers or other workflow identifiers.

        basedOn: A procedure that is fulfilled in whole or in part by the creation of this
            media.

        type: Whether the media is a photo (still image), an audio recording, or a video
            recording.

        subtype: Details of the type of the media - usually, how it was acquired (what type of
            device). If images sourced from a DICOM system, are wrapped in a Media
            resource, then this is the modality.

        view: The name of the imaging view e.g. Lateral or Antero-posterior (AP).

        subject: Who/What this Media is a record of.

        context: The encounter or episode of care that establishes the context for this media.

        occurrenceDateTime: The date and time(s) at which the media was collected.

        occurrencePeriod: The date and time(s) at which the media was collected.

        operator: The person who administered the collection of the image.

        reasonCode: Describes why the event occurred in coded or textual form.

        bodySite: Indicates the site on the subject's body where the media was collected (i.e.
            the target site).

        device: The device used to collect the media.

        height: Height of the image in pixels (photo/video).

        width: Width of the image in pixels (photo/video).

        frames: The number of frames in a photo. This is used with a multi-page fax, or an
            imaging acquisition context that takes multiple slices in a single image, or
            an animated gif. If there is more than one frame, this SHALL have a value in
            order to alert interface software that a multi-frame capable rendering widget
            is required.

        duration: The duration of the recording in seconds - for audio and video.

        content: The actual content of the media - inline or by direct reference to the media
            source file.

        note: Comments made about the media by the performer, subject or other participants.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.attachment import AttachmentSchema
        from spark_fhir_schemas.stu3.complex_types.annotation import AnnotationSchema
        if (
            max_recursion_limit
            and nesting_list.count("Media") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Media"]
        schema = StructType(
            [
                # This is a Media resource
                StructField("resourceType", StringType(), True),
                # Identifiers associated with the image - these may include identifiers for the
                # image itself, identifiers for the context of its collection (e.g. series ids)
                # and context ids such as accession numbers or other workflow identifiers.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A procedure that is fulfilled in whole or in part by the creation of this
                # media.
                StructField(
                    "basedOn",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Whether the media is a photo (still image), an audio recording, or a video
                # recording.
                StructField("type", StringType(), True),
                # Details of the type of the media - usually, how it was acquired (what type of
                # device). If images sourced from a DICOM system, are wrapped in a Media
                # resource, then this is the modality.
                StructField(
                    "subtype",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The name of the imaging view e.g. Lateral or Antero-posterior (AP).
                StructField(
                    "view",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Who/What this Media is a record of.
                StructField(
                    "subject",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The encounter or episode of care that establishes the context for this media.
                StructField(
                    "context",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The date and time(s) at which the media was collected.
                StructField("occurrenceDateTime", StringType(), True),
                # The date and time(s) at which the media was collected.
                StructField(
                    "occurrencePeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The person who administered the collection of the image.
                StructField(
                    "operator",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Describes why the event occurred in coded or textual form.
                StructField(
                    "reasonCode",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Indicates the site on the subject's body where the media was collected (i.e.
                # the target site).
                StructField(
                    "bodySite",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The device used to collect the media.
                StructField(
                    "device",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Height of the image in pixels (photo/video).
                StructField("height", IntegerType(), True),
                # Width of the image in pixels (photo/video).
                StructField("width", IntegerType(), True),
                # The number of frames in a photo. This is used with a multi-page fax, or an
                # imaging acquisition context that takes multiple slices in a single image, or
                # an animated gif. If there is more than one frame, this SHALL have a value in
                # order to alert interface software that a multi-frame capable rendering widget
                # is required.
                StructField("frames", IntegerType(), True),
                # The duration of the recording in seconds - for audio and video.
                StructField("duration", IntegerType(), True),
                # The actual content of the media - inline or by direct reference to the media
                # source file.
                StructField(
                    "content",
                    AttachmentSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Comments made about the media by the performer, subject or other participants.
                StructField(
                    "note",
                    ArrayType(
                        AnnotationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
