from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class MeasureReport_GroupSchema:
    """
    The MeasureReport resource contains the results of evaluating a measure.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        The MeasureReport resource contains the results of evaluating a measure.


        identifier: The identifier of the population group as defined in the measure definition.

        population: The populations that make up the population group, one for each type of
            population appropriate for the measure.

        measureScore: The measure score for this population group, calculated as appropriate for the
            measure type and scoring method, and based on the contents of the populations
            defined in the group.

        stratifier: When a measure includes multiple stratifiers, there will be a stratifier group
            for each stratifier defined by the measure.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.measurereport_population import MeasureReport_PopulationSchema
        from spark_fhir_schemas.stu3.complex_types.measurereport_stratifier import MeasureReport_StratifierSchema
        if (
            max_recursion_limit and
            nesting_list.count("MeasureReport_Group") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["MeasureReport_Group"]
        schema = StructType(
            [
                # The identifier of the population group as defined in the measure definition.
                StructField(
                    "identifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The populations that make up the population group, one for each type of
                # population appropriate for the measure.
                StructField(
                    "population",
                    ArrayType(
                        MeasureReport_PopulationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The measure score for this population group, calculated as appropriate for the
                # measure type and scoring method, and based on the contents of the populations
                # defined in the group.
                StructField("measureScore", IntegerType(), True),
                # When a measure includes multiple stratifiers, there will be a stratifier group
                # for each stratifier defined by the measure.
                StructField(
                    "stratifier",
                    ArrayType(
                        MeasureReport_StratifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
