from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class MeasureReportSchema:
    """
    The MeasureReport resource contains the results of evaluating a measure.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        The MeasureReport resource contains the results of evaluating a measure.


        resourceType: This is a MeasureReport resource

        identifier: A formal identifier that is used to identify this report when it is
            represented in other formats, or referenced in a specification, model, design
            or an instance.

        status: The report status. No data will be available until the report status is
            complete.

        type: The type of measure report. This may be an individual report, which provides a
            single patient's score for the measure; a patient listing, which returns the
            list of patients that meet the various criteria in the measure; or a summary
            report, which returns a population count for each of the criteria in the
            measure.

        measure: A reference to the Measure that was evaluated to produce this report.

        patient: Optional Patient if the report was requested for a single patient.

        date: The date this measure report was generated.

        reportingOrganization: Reporting Organization.

        period: The reporting period for which the report was calculated.

        group: The results of the calculation, one for each population group in the measure.

        evaluatedResources: A reference to a Bundle containing the Resources that were used in the
            evaluation of this report.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.measurereport_group import MeasureReport_GroupSchema
        if (
            max_recursion_limit
            and nesting_list.count("MeasureReport") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["MeasureReport"]
        schema = StructType(
            [
                # This is a MeasureReport resource
                StructField("resourceType", StringType(), True),
                # A formal identifier that is used to identify this report when it is
                # represented in other formats, or referenced in a specification, model, design
                # or an instance.
                StructField(
                    "identifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The report status. No data will be available until the report status is
                # complete.
                StructField("status", StringType(), True),
                # The type of measure report. This may be an individual report, which provides a
                # single patient's score for the measure; a patient listing, which returns the
                # list of patients that meet the various criteria in the measure; or a summary
                # report, which returns a population count for each of the criteria in the
                # measure.
                StructField("type", StringType(), True),
                # A reference to the Measure that was evaluated to produce this report.
                StructField(
                    "measure",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Optional Patient if the report was requested for a single patient.
                StructField(
                    "patient",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The date this measure report was generated.
                StructField("date", StringType(), True),
                # Reporting Organization.
                StructField(
                    "reportingOrganization",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The reporting period for which the report was calculated.
                StructField(
                    "period",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The results of the calculation, one for each population group in the measure.
                StructField(
                    "group",
                    ArrayType(
                        MeasureReport_GroupSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A reference to a Bundle containing the Resources that were used in the
                # evaluation of this report.
                StructField(
                    "evaluatedResources",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
