from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Measure_GroupSchema:
    """
    The Measure resource provides the definition of a quality measure.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        The Measure resource provides the definition of a quality measure.


        identifier: A unique identifier for the group. This identifier will used to report data
            for the group in the measure report.

        name: Optional name or short description of this group.

        description: The human readable description of this population group.

        population: A population criteria for the measure.

        stratifier: The stratifier criteria for the measure report, specified as either the name
            of a valid CQL expression defined within a referenced library, or a valid FHIR
            Resource Path.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.measure_population import Measure_PopulationSchema
        from spark_fhir_schemas.stu3.complex_types.measure_stratifier import Measure_StratifierSchema
        if (
            max_recursion_limit
            and nesting_list.count("Measure_Group") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Measure_Group"]
        schema = StructType(
            [
                # A unique identifier for the group. This identifier will used to report data
                # for the group in the measure report.
                StructField(
                    "identifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Optional name or short description of this group.
                StructField("name", StringType(), True),
                # The human readable description of this population group.
                StructField("description", StringType(), True),
                # A population criteria for the measure.
                StructField(
                    "population",
                    ArrayType(
                        Measure_PopulationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The stratifier criteria for the measure report, specified as either the name
                # of a valid CQL expression defined within a referenced library, or a valid FHIR
                # Resource Path.
                StructField(
                    "stratifier",
                    ArrayType(
                        Measure_StratifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
