from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ListSchema:
    """
    A set of information summarized from a list of other resources.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A set of information summarized from a list of other resources.


        resourceType: This is a List resource

        identifier: Identifier for the List assigned for business purposes outside the context of
            FHIR.

        status: Indicates the current state of this list.

        mode: How this list was prepared - whether it is a working list that is suitable for
            being maintained on an ongoing basis, or if it represents a snapshot of a list
            of items from another source, or whether it is a prepared list where items may
            be marked as added, modified or deleted.

        title: A label for the list assigned by the author.

        code: This code defines the purpose of the list - why it was created.

        subject: The common subject (or patient) of the resources that are in the list, if
            there is one.

        encounter: The encounter that is the context in which this list was created.

        date: The date that the list was prepared.

        source: The entity responsible for deciding what the contents of the list were. Where
            the list was created by a human, this is the same as the author of the list.

        orderedBy: What order applies to the items in the list.

        note: Comments that apply to the overall list.

        entry: Entries in this list.

        emptyReason: If the list is empty, why the list is empty.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.annotation import AnnotationSchema
        from spark_fhir_schemas.stu3.complex_types.list_entry import List_EntrySchema
        if (
            max_recursion_limit
            and nesting_list.count("List") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["List"]
        schema = StructType(
            [
                # This is a List resource
                StructField("resourceType", StringType(), True),
                # Identifier for the List assigned for business purposes outside the context of
                # FHIR.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Indicates the current state of this list.
                StructField("status", StringType(), True),
                # How this list was prepared - whether it is a working list that is suitable for
                # being maintained on an ongoing basis, or if it represents a snapshot of a list
                # of items from another source, or whether it is a prepared list where items may
                # be marked as added, modified or deleted.
                StructField("mode", StringType(), True),
                # A label for the list assigned by the author.
                StructField("title", StringType(), True),
                # This code defines the purpose of the list - why it was created.
                StructField(
                    "code",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The common subject (or patient) of the resources that are in the list, if
                # there is one.
                StructField(
                    "subject",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The encounter that is the context in which this list was created.
                StructField(
                    "encounter",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The date that the list was prepared.
                StructField("date", StringType(), True),
                # The entity responsible for deciding what the contents of the list were. Where
                # the list was created by a human, this is the same as the author of the list.
                StructField(
                    "source",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # What order applies to the items in the list.
                StructField(
                    "orderedBy",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Comments that apply to the overall list.
                StructField(
                    "note",
                    ArrayType(
                        AnnotationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Entries in this list.
                StructField(
                    "entry",
                    ArrayType(
                        List_EntrySchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # If the list is empty, why the list is empty.
                StructField(
                    "emptyReason",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
