from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class LinkageSchema:
    """
    Identifies two or more records (resource instances) that are referring to the
    same real-world "occurrence".
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        Identifies two or more records (resource instances) that are referring to the
        same real-world "occurrence".


        resourceType: This is a Linkage resource

        active: Indicates whether the asserted set of linkages are considered to be "in
            effect".

        author: Identifies the user or organization responsible for asserting the linkages and
            who establishes the context for evaluating the nature of each linkage.

        item: Identifies one of the records that is considered to refer to the same real-
            world occurrence as well as how the items hould be evaluated within the
            collection of linked items.

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.linkage_item import Linkage_ItemSchema
        if (
            max_recursion_limit
            and nesting_list.count("Linkage") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Linkage"]
        schema = StructType(
            [
                # This is a Linkage resource
                StructField("resourceType", StringType(), True),
                # Indicates whether the asserted set of linkages are considered to be "in
                # effect".
                StructField("active", BooleanType(), True),
                # Identifies the user or organization responsible for asserting the linkages and
                # who establishes the context for evaluating the nature of each linkage.
                StructField(
                    "author",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Identifies one of the records that is considered to refer to the same real-
                # world occurrence as well as how the items hould be evaluated within the
                # collection of linked items.
                StructField(
                    "item",
                    ArrayType(
                        Linkage_ItemSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
