from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ImplementationGuideSchema:
    """
    A set of rules of how FHIR is used to solve a particular problem. This
    resource is used to gather all the parts of an implementation guide into a
    logical whole and to publish a computable definition of all the parts.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A set of rules of how FHIR is used to solve a particular problem. This
        resource is used to gather all the parts of an implementation guide into a
        logical whole and to publish a computable definition of all the parts.


        resourceType: This is a ImplementationGuide resource

        url: An absolute URI that is used to identify this implementation guide when it is
            referenced in a specification, model, design or an instance. This SHALL be a
            URL, SHOULD be globally unique, and SHOULD be an address at which this
            implementation guide is (or will be) published. The URL SHOULD include the
            major version of the implementation guide. For more information see [Technical
            and Business Versions](resource.html#versions).

        version: The identifier that is used to identify this version of the implementation
            guide when it is referenced in a specification, model, design or instance.
            This is an arbitrary value managed by the implementation guide author and is
            not expected to be globally unique. For example, it might be a timestamp (e.g.
            yyyymmdd) if a managed version is not available. There is also no expectation
            that versions can be placed in a lexicographical sequence.

        name: A natural language name identifying the implementation guide. This name should
            be usable as an identifier for the module by machine processing applications
            such as code generation.

        status: The status of this implementation guide. Enables tracking the life-cycle of
            the content.

        experimental: A boolean value to indicate that this implementation guide is authored for
            testing purposes (or education/evaluation/marketing), and is not intended to
            be used for genuine usage.

        date: The date  (and optionally time) when the implementation guide was published.
            The date must change if and when the business version changes and it must
            change if the status code changes. In addition, it should change when the
            substantive content of the implementation guide changes.

        publisher: The name of the individual or organization that published the implementation
            guide.

        contact: Contact details to assist a user in finding and communicating with the
            publisher.

        description: A free text natural language description of the implementation guide from a
            consumer's perspective.

        useContext: The content was developed with a focus and intent of supporting the contexts
            that are listed. These terms may be used to assist with indexing and searching
            for appropriate implementation guide instances.

        jurisdiction: A legal or geographic region in which the implementation guide is intended to
            be used.

        copyright: A copyright statement relating to the implementation guide and/or its
            contents. Copyright statements are generally legal restrictions on the use and
            publishing of the implementation guide.

        fhirVersion: The version of the FHIR specification on which this ImplementationGuide is
            based - this is the formal version of the specification, without the revision
            number, e.g. [publication].[major].[minor], which is 3.0.1 for this version.

        dependency: Another implementation guide that this implementation depends on. Typically,
            an implementation guide uses value sets, profiles etc.defined in other
            implementation guides.

        package: A logical group of resources. Logical groups can be used when building pages.

        global: A set of profiles that all resources covered by this implementation guide must
            conform to.

        binary: A binary file that is included in the  implementation guide when it is
            published.

        page: A page / section in the implementation guide. The root page is the
            implementation guide home page.

        """
        from spark_fhir_schemas.stu3.complex_types.contactdetail import ContactDetailSchema
        from spark_fhir_schemas.stu3.complex_types.usagecontext import UsageContextSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.implementationguide_dependency import ImplementationGuide_DependencySchema
        from spark_fhir_schemas.stu3.complex_types.implementationguide_package import ImplementationGuide_PackageSchema
        from spark_fhir_schemas.stu3.complex_types.implementationguide_global import ImplementationGuide_GlobalSchema
        from spark_fhir_schemas.stu3.complex_types.implementationguide_page import ImplementationGuide_PageSchema
        if (
            max_recursion_limit and
            nesting_list.count("ImplementationGuide") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ImplementationGuide"]
        schema = StructType(
            [
                # This is a ImplementationGuide resource
                StructField("resourceType", StringType(), True),
                # An absolute URI that is used to identify this implementation guide when it is
                # referenced in a specification, model, design or an instance. This SHALL be a
                # URL, SHOULD be globally unique, and SHOULD be an address at which this
                # implementation guide is (or will be) published. The URL SHOULD include the
                # major version of the implementation guide. For more information see [Technical
                # and Business Versions](resource.html#versions).
                StructField("url", StringType(), True),
                # The identifier that is used to identify this version of the implementation
                # guide when it is referenced in a specification, model, design or instance.
                # This is an arbitrary value managed by the implementation guide author and is
                # not expected to be globally unique. For example, it might be a timestamp (e.g.
                # yyyymmdd) if a managed version is not available. There is also no expectation
                # that versions can be placed in a lexicographical sequence.
                StructField("version", StringType(), True),
                # A natural language name identifying the implementation guide. This name should
                # be usable as an identifier for the module by machine processing applications
                # such as code generation.
                StructField("name", StringType(), True),
                # The status of this implementation guide. Enables tracking the life-cycle of
                # the content.
                StructField("status", StringType(), True),
                # A boolean value to indicate that this implementation guide is authored for
                # testing purposes (or education/evaluation/marketing), and is not intended to
                # be used for genuine usage.
                StructField("experimental", BooleanType(), True),
                # The date  (and optionally time) when the implementation guide was published.
                # The date must change if and when the business version changes and it must
                # change if the status code changes. In addition, it should change when the
                # substantive content of the implementation guide changes.
                StructField("date", StringType(), True),
                # The name of the individual or organization that published the implementation
                # guide.
                StructField("publisher", StringType(), True),
                # Contact details to assist a user in finding and communicating with the
                # publisher.
                StructField(
                    "contact",
                    ArrayType(
                        ContactDetailSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A free text natural language description of the implementation guide from a
                # consumer's perspective.
                StructField("description", StringType(), True),
                # The content was developed with a focus and intent of supporting the contexts
                # that are listed. These terms may be used to assist with indexing and searching
                # for appropriate implementation guide instances.
                StructField(
                    "useContext",
                    ArrayType(
                        UsageContextSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A legal or geographic region in which the implementation guide is intended to
                # be used.
                StructField(
                    "jurisdiction",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A copyright statement relating to the implementation guide and/or its
                # contents. Copyright statements are generally legal restrictions on the use and
                # publishing of the implementation guide.
                StructField("copyright", StringType(), True),
                # The version of the FHIR specification on which this ImplementationGuide is
                # based - this is the formal version of the specification, without the revision
                # number, e.g. [publication].[major].[minor], which is 3.0.1 for this version.
                StructField("fhirVersion", StringType(), True),
                # Another implementation guide that this implementation depends on. Typically,
                # an implementation guide uses value sets, profiles etc.defined in other
                # implementation guides.
                StructField(
                    "dependency",
                    ArrayType(
                        ImplementationGuide_DependencySchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A logical group of resources. Logical groups can be used when building pages.
                StructField(
                    "package",
                    ArrayType(
                        ImplementationGuide_PackageSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A set of profiles that all resources covered by this implementation guide must
                # conform to.
                StructField(
                    "global",
                    ArrayType(
                        ImplementationGuide_GlobalSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A binary file that is included in the  implementation guide when it is
                # published.
                # A page / section in the implementation guide. The root page is the
                # implementation guide home page.
                StructField(
                    "page",
                    ImplementationGuide_PageSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
