from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ImmunizationRecommendation_DateCriterionSchema:
    """
    A patient's point-in-time immunization and recommendation (i.e. forecasting a
    patient's immunization eligibility according to a published schedule) with
    optional supporting justification.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A patient's point-in-time immunization and recommendation (i.e. forecasting a
        patient's immunization eligibility according to a published schedule) with
        optional supporting justification.


        code: Date classification of recommendation.  For example, earliest date to give,
            latest date to give, etc.

        value: The date whose meaning is specified by dateCriterion.code.

        """
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        if (
            max_recursion_limit
            and nesting_list.count("ImmunizationRecommendation_DateCriterion")
            >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + [
            "ImmunizationRecommendation_DateCriterion"
        ]
        schema = StructType(
            [
                # Date classification of recommendation.  For example, earliest date to give,
                # latest date to give, etc.
                StructField(
                    "code",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The date whose meaning is specified by dateCriterion.code.
                StructField("value", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
