from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ImmunizationSchema:
    """
    Describes the event of a patient being administered a vaccination or a record
    of a vaccination as reported by a patient, a clinician or another party and
    may include vaccine reaction information and what vaccination protocol was
    followed.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        Describes the event of a patient being administered a vaccination or a record
        of a vaccination as reported by a patient, a clinician or another party and
        may include vaccine reaction information and what vaccination protocol was
        followed.


        resourceType: This is a Immunization resource

        identifier: A unique identifier assigned to this immunization record.

        status: Indicates the current status of the vaccination event.

        notGiven: Indicates if the vaccination was or was not given.

        vaccineCode: Vaccine that was administered or was to be administered.

        patient: The patient who either received or did not receive the immunization.

        encounter: The visit or admission or other contact between patient and health care
            provider the immunization was performed as part of.

        date: Date vaccine administered or was to be administered.

        primarySource: An indication that the content of the record is based on information from the
            person who administered the vaccine. This reflects the context under which the
            data was originally recorded.

        reportOrigin: The source of the data when the report of the immunization event is not based
            on information from the person who administered the vaccine.

        location: The service delivery location where the vaccine administration occurred.

        manufacturer: Name of vaccine manufacturer.

        lotNumber: Lot number of the  vaccine product.

        expirationDate: Date vaccine batch expires.

        site: Body site where vaccine was administered.

        route: The path by which the vaccine product is taken into the body.

        doseQuantity: The quantity of vaccine product that was administered.

        practitioner: Indicates who or what performed the event.

        note: Extra information about the immunization that is not conveyed by the other
            attributes.

        explanation: Reasons why a vaccine was or was not administered.

        reaction: Categorical data indicating that an adverse event is associated in time to an
            immunization.

        vaccinationProtocol: Contains information about the protocol(s) under which the vaccine was
            administered.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.quantity import QuantitySchema
        from spark_fhir_schemas.stu3.complex_types.immunization_practitioner import Immunization_PractitionerSchema
        from spark_fhir_schemas.stu3.complex_types.annotation import AnnotationSchema
        from spark_fhir_schemas.stu3.complex_types.immunization_explanation import Immunization_ExplanationSchema
        from spark_fhir_schemas.stu3.complex_types.immunization_reaction import Immunization_ReactionSchema
        from spark_fhir_schemas.stu3.complex_types.immunization_vaccinationprotocol import Immunization_VaccinationProtocolSchema
        if (
            max_recursion_limit
            and nesting_list.count("Immunization") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Immunization"]
        schema = StructType(
            [
                # This is a Immunization resource
                StructField("resourceType", StringType(), True),
                # A unique identifier assigned to this immunization record.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Indicates the current status of the vaccination event.
                StructField("status", StringType(), True),
                # Indicates if the vaccination was or was not given.
                StructField("notGiven", BooleanType(), True),
                # Vaccine that was administered or was to be administered.
                StructField(
                    "vaccineCode",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The patient who either received or did not receive the immunization.
                StructField(
                    "patient",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The visit or admission or other contact between patient and health care
                # provider the immunization was performed as part of.
                StructField(
                    "encounter",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Date vaccine administered or was to be administered.
                StructField("date", StringType(), True),
                # An indication that the content of the record is based on information from the
                # person who administered the vaccine. This reflects the context under which the
                # data was originally recorded.
                StructField("primarySource", BooleanType(), True),
                # The source of the data when the report of the immunization event is not based
                # on information from the person who administered the vaccine.
                StructField(
                    "reportOrigin",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The service delivery location where the vaccine administration occurred.
                StructField(
                    "location",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Name of vaccine manufacturer.
                StructField(
                    "manufacturer",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Lot number of the  vaccine product.
                StructField("lotNumber", StringType(), True),
                # Date vaccine batch expires.
                StructField("expirationDate", StringType(), True),
                # Body site where vaccine was administered.
                StructField(
                    "site",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The path by which the vaccine product is taken into the body.
                StructField(
                    "route",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The quantity of vaccine product that was administered.
                StructField(
                    "doseQuantity",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Indicates who or what performed the event.
                StructField(
                    "practitioner",
                    ArrayType(
                        Immunization_PractitionerSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Extra information about the immunization that is not conveyed by the other
                # attributes.
                StructField(
                    "note",
                    ArrayType(
                        AnnotationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Reasons why a vaccine was or was not administered.
                StructField(
                    "explanation",
                    Immunization_ExplanationSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Categorical data indicating that an adverse event is associated in time to an
                # immunization.
                StructField(
                    "reaction",
                    ArrayType(
                        Immunization_ReactionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Contains information about the protocol(s) under which the vaccine was
                # administered.
                StructField(
                    "vaccinationProtocol",
                    ArrayType(
                        Immunization_VaccinationProtocolSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
