from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class HealthcareServiceSchema:
    """
    The details of a healthcare service available at a location.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        The details of a healthcare service available at a location.


        resourceType: This is a HealthcareService resource

        identifier: External identifiers for this item.

        active: Whether this healthcareservice record is in active use.

        providedBy: The organization that provides this healthcare service.

        category: Identifies the broad category of service being performed or delivered.

        type: The specific type of service that may be delivered or performed.

        specialty: Collection of specialties handled by the service site. This is more of a
            medical term.

        location: The location(s) where this healthcare service may be provided.

        name: Further description of the service as it would be presented to a consumer
            while searching.

        comment: Any additional description of the service and/or any specific issues not
            covered by the other attributes, which can be displayed as further detail
            under the serviceName.

        extraDetails: Extra details about the service that can't be placed in the other fields.

        photo: If there is a photo/symbol associated with this HealthcareService, it may be
            included here to facilitate quick identification of the service in a list.

        telecom: List of contacts related to this specific healthcare service.

        coverageArea: The location(s) that this service is available to (not where the service is
            provided).

        serviceProvisionCode: The code(s) that detail the conditions under which the healthcare service is
            available/offered.

        eligibility: Does this service have specific eligibility requirements that need to be met
            in order to use the service?

        eligibilityNote: Describes the eligibility conditions for the service.

        programName: Program Names that can be used to categorize the service.

        characteristic: Collection of characteristics (attributes).

        referralMethod: Ways that the service accepts referrals, if this is not provided then it is
            implied that no referral is required.

        appointmentRequired: Indicates whether or not a prospective consumer will require an appointment
            for a particular service at a site to be provided by the Organization.
            Indicates if an appointment is required for access to this service.

        availableTime: A collection of times that the Service Site is available.

        notAvailable: The HealthcareService is not available during this period of time due to the
            provided reason.

        availabilityExceptions: A description of site availability exceptions, e.g. public holiday
            availability. Succinctly describing all possible exceptions to normal site
            availability as details in the available Times and not available Times.

        endpoint: Technical endpoints providing access to services operated for the specific
            healthcare services defined at this resource.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.attachment import AttachmentSchema
        from spark_fhir_schemas.stu3.complex_types.contactpoint import ContactPointSchema
        from spark_fhir_schemas.stu3.complex_types.healthcareservice_availabletime import HealthcareService_AvailableTimeSchema
        from spark_fhir_schemas.stu3.complex_types.healthcareservice_notavailable import HealthcareService_NotAvailableSchema
        if (
            max_recursion_limit
            and nesting_list.count("HealthcareService") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["HealthcareService"]
        schema = StructType(
            [
                # This is a HealthcareService resource
                StructField("resourceType", StringType(), True),
                # External identifiers for this item.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Whether this healthcareservice record is in active use.
                StructField("active", BooleanType(), True),
                # The organization that provides this healthcare service.
                StructField(
                    "providedBy",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Identifies the broad category of service being performed or delivered.
                StructField(
                    "category",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The specific type of service that may be delivered or performed.
                StructField(
                    "type",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Collection of specialties handled by the service site. This is more of a
                # medical term.
                StructField(
                    "specialty",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The location(s) where this healthcare service may be provided.
                StructField(
                    "location",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Further description of the service as it would be presented to a consumer
                # while searching.
                StructField("name", StringType(), True),
                # Any additional description of the service and/or any specific issues not
                # covered by the other attributes, which can be displayed as further detail
                # under the serviceName.
                StructField("comment", StringType(), True),
                # Extra details about the service that can't be placed in the other fields.
                StructField("extraDetails", StringType(), True),
                # If there is a photo/symbol associated with this HealthcareService, it may be
                # included here to facilitate quick identification of the service in a list.
                StructField(
                    "photo",
                    AttachmentSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # List of contacts related to this specific healthcare service.
                StructField(
                    "telecom",
                    ArrayType(
                        ContactPointSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The location(s) that this service is available to (not where the service is
                # provided).
                StructField(
                    "coverageArea",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The code(s) that detail the conditions under which the healthcare service is
                # available/offered.
                StructField(
                    "serviceProvisionCode",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Does this service have specific eligibility requirements that need to be met
                # in order to use the service?
                StructField(
                    "eligibility",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Describes the eligibility conditions for the service.
                StructField("eligibilityNote", StringType(), True),
                # Program Names that can be used to categorize the service.
                # Collection of characteristics (attributes).
                StructField(
                    "characteristic",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Ways that the service accepts referrals, if this is not provided then it is
                # implied that no referral is required.
                StructField(
                    "referralMethod",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Indicates whether or not a prospective consumer will require an appointment
                # for a particular service at a site to be provided by the Organization.
                # Indicates if an appointment is required for access to this service.
                StructField("appointmentRequired", BooleanType(), True),
                # A collection of times that the Service Site is available.
                StructField(
                    "availableTime",
                    ArrayType(
                        HealthcareService_AvailableTimeSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The HealthcareService is not available during this period of time due to the
                # provided reason.
                StructField(
                    "notAvailable",
                    ArrayType(
                        HealthcareService_NotAvailableSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A description of site availability exceptions, e.g. public holiday
                # availability. Succinctly describing all possible exceptions to normal site
                # availability as details in the available Times and not available Times.
                StructField("availabilityExceptions", StringType(), True),
                # Technical endpoints providing access to services operated for the specific
                # healthcare services defined at this resource.
                StructField(
                    "endpoint",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
