from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Group_CharacteristicSchema:
    """
    Represents a defined collection of entities that may be discussed or acted
    upon collectively but which are not expected to act collectively and are not
    formally or legally recognized; i.e. a collection of entities that isn't an
    Organization.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        Represents a defined collection of entities that may be discussed or acted
        upon collectively but which are not expected to act collectively and are not
        formally or legally recognized; i.e. a collection of entities that isn't an
        Organization.


        code: A code that identifies the kind of trait being asserted.

        valueCodeableConcept: The value of the trait that holds (or does not hold - see 'exclude') for
            members of the group.

        valueBoolean: The value of the trait that holds (or does not hold - see 'exclude') for
            members of the group.

        valueQuantity: The value of the trait that holds (or does not hold - see 'exclude') for
            members of the group.

        valueRange: The value of the trait that holds (or does not hold - see 'exclude') for
            members of the group.

        exclude: If true, indicates the characteristic is one that is NOT held by members of
            the group.

        period: The period over which the characteristic is tested; e.g. the patient had an
            operation during the month of June.

        """
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.quantity import QuantitySchema
        from spark_fhir_schemas.stu3.complex_types.range import RangeSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        if (
            max_recursion_limit and
            nesting_list.count("Group_Characteristic") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Group_Characteristic"]
        schema = StructType(
            [
                # A code that identifies the kind of trait being asserted.
                StructField(
                    "code",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The value of the trait that holds (or does not hold - see 'exclude') for
                # members of the group.
                StructField(
                    "valueCodeableConcept",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The value of the trait that holds (or does not hold - see 'exclude') for
                # members of the group.
                StructField("valueBoolean", BooleanType(), True),
                # The value of the trait that holds (or does not hold - see 'exclude') for
                # members of the group.
                StructField(
                    "valueQuantity",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The value of the trait that holds (or does not hold - see 'exclude') for
                # members of the group.
                StructField(
                    "valueRange",
                    RangeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # If true, indicates the characteristic is one that is NOT held by members of
                # the group.
                StructField("exclude", BooleanType(), True),
                # The period over which the characteristic is tested; e.g. the patient had an
                # operation during the month of June.
                StructField(
                    "period",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
