from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class GraphDefinition_TargetSchema:
    """
    A formal computable definition of a graph of resources - that is, a coherent
    set of resources that form a graph by following references. The Graph
    Definition resource defines a set and makes rules about the set.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A formal computable definition of a graph of resources - that is, a coherent
        set of resources that form a graph by following references. The Graph
        Definition resource defines a set and makes rules about the set.


        type: Type of resource this link refers to.

        profile: Profile for the target resource.

        compartment: Compartment Consistency Rules.

        link: Additional links from target resource.

        """
        from spark_fhir_schemas.stu3.complex_types.graphdefinition_compartment import GraphDefinition_CompartmentSchema
        from spark_fhir_schemas.stu3.complex_types.graphdefinition_link import GraphDefinition_LinkSchema
        if (
            max_recursion_limit and
            nesting_list.count("GraphDefinition_Target") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["GraphDefinition_Target"]
        schema = StructType(
            [
                # Type of resource this link refers to.
                StructField("type", StringType(), True),
                # Profile for the target resource.
                StructField("profile", StringType(), True),
                # Compartment Consistency Rules.
                StructField(
                    "compartment",
                    ArrayType(
                        GraphDefinition_CompartmentSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Additional links from target resource.
                StructField(
                    "link",
                    ArrayType(
                        GraphDefinition_LinkSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
