from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class GraphDefinition_LinkSchema:
    """
    A formal computable definition of a graph of resources - that is, a coherent
    set of resources that form a graph by following references. The Graph
    Definition resource defines a set and makes rules about the set.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A formal computable definition of a graph of resources - that is, a coherent
        set of resources that form a graph by following references. The Graph
        Definition resource defines a set and makes rules about the set.


        path: Path in the resource that contains the link.

        sliceName: Which slice (if profiled).

        min: Minimum occurrences for this link.

        max: Maximum occurrences for this link.

        description: Information about why this link is of interest in this graph definition.

        target: Potential target for the link.

        """
        from spark_fhir_schemas.stu3.complex_types.graphdefinition_target import GraphDefinition_TargetSchema
        if (
            max_recursion_limit and
            nesting_list.count("GraphDefinition_Link") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["GraphDefinition_Link"]
        schema = StructType(
            [
                # Path in the resource that contains the link.
                StructField("path", StringType(), True),
                # Which slice (if profiled).
                StructField("sliceName", StringType(), True),
                # Minimum occurrences for this link.
                StructField("min", IntegerType(), True),
                # Maximum occurrences for this link.
                StructField("max", StringType(), True),
                # Information about why this link is of interest in this graph definition.
                StructField("description", StringType(), True),
                # Potential target for the link.
                StructField(
                    "target",
                    ArrayType(
                        GraphDefinition_TargetSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
