from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class GraphDefinitionSchema:
    """
    A formal computable definition of a graph of resources - that is, a coherent
    set of resources that form a graph by following references. The Graph
    Definition resource defines a set and makes rules about the set.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A formal computable definition of a graph of resources - that is, a coherent
        set of resources that form a graph by following references. The Graph
        Definition resource defines a set and makes rules about the set.


        resourceType: This is a GraphDefinition resource

        url: An absolute URI that is used to identify this graph definition when it is
            referenced in a specification, model, design or an instance. This SHALL be a
            URL, SHOULD be globally unique, and SHOULD be an address at which this graph
            definition is (or will be) published. The URL SHOULD include the major version
            of the graph definition. For more information see [Technical and Business
            Versions](resource.html#versions).

        version: The identifier that is used to identify this version of the graph definition
            when it is referenced in a specification, model, design or instance. This is
            an arbitrary value managed by the graph definition author and is not expected
            to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if
            a managed version is not available. There is also no expectation that versions
            can be placed in a lexicographical sequence.

        name: A natural language name identifying the graph definition. This name should be
            usable as an identifier for the module by machine processing applications such
            as code generation.

        status: The status of this graph definition. Enables tracking the life-cycle of the
            content.

        experimental: A boolean value to indicate that this graph definition is authored for testing
            purposes (or education/evaluation/marketing), and is not intended to be used
            for genuine usage.

        date: The date  (and optionally time) when the graph definition was published. The
            date must change if and when the business version changes and it must change
            if the status code changes. In addition, it should change when the substantive
            content of the graph definition changes.

        publisher: The name of the individual or organization that published the graph
            definition.

        contact: Contact details to assist a user in finding and communicating with the
            publisher.

        description: A free text natural language description of the graph definition from a
            consumer's perspective.

        useContext: The content was developed with a focus and intent of supporting the contexts
            that are listed. These terms may be used to assist with indexing and searching
            for appropriate graph definition instances.

        jurisdiction: A legal or geographic region in which the graph definition is intended to be
            used.

        purpose: Explaination of why this graph definition is needed and why it has been
            designed as it has.

        start: The type of FHIR resource at which instances of this graph start.

        profile: The profile that describes the use of the base resource.

        link: Links this graph makes rules about.

        """
        from spark_fhir_schemas.stu3.complex_types.contactdetail import ContactDetailSchema
        from spark_fhir_schemas.stu3.complex_types.usagecontext import UsageContextSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.graphdefinition_link import GraphDefinition_LinkSchema
        if (
            max_recursion_limit
            and nesting_list.count("GraphDefinition") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["GraphDefinition"]
        schema = StructType(
            [
                # This is a GraphDefinition resource
                StructField("resourceType", StringType(), True),
                # An absolute URI that is used to identify this graph definition when it is
                # referenced in a specification, model, design or an instance. This SHALL be a
                # URL, SHOULD be globally unique, and SHOULD be an address at which this graph
                # definition is (or will be) published. The URL SHOULD include the major version
                # of the graph definition. For more information see [Technical and Business
                # Versions](resource.html#versions).
                StructField("url", StringType(), True),
                # The identifier that is used to identify this version of the graph definition
                # when it is referenced in a specification, model, design or instance. This is
                # an arbitrary value managed by the graph definition author and is not expected
                # to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if
                # a managed version is not available. There is also no expectation that versions
                # can be placed in a lexicographical sequence.
                StructField("version", StringType(), True),
                # A natural language name identifying the graph definition. This name should be
                # usable as an identifier for the module by machine processing applications such
                # as code generation.
                StructField("name", StringType(), True),
                # The status of this graph definition. Enables tracking the life-cycle of the
                # content.
                StructField("status", StringType(), True),
                # A boolean value to indicate that this graph definition is authored for testing
                # purposes (or education/evaluation/marketing), and is not intended to be used
                # for genuine usage.
                StructField("experimental", BooleanType(), True),
                # The date  (and optionally time) when the graph definition was published. The
                # date must change if and when the business version changes and it must change
                # if the status code changes. In addition, it should change when the substantive
                # content of the graph definition changes.
                StructField("date", StringType(), True),
                # The name of the individual or organization that published the graph
                # definition.
                StructField("publisher", StringType(), True),
                # Contact details to assist a user in finding and communicating with the
                # publisher.
                StructField(
                    "contact",
                    ArrayType(
                        ContactDetailSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A free text natural language description of the graph definition from a
                # consumer's perspective.
                StructField("description", StringType(), True),
                # The content was developed with a focus and intent of supporting the contexts
                # that are listed. These terms may be used to assist with indexing and searching
                # for appropriate graph definition instances.
                StructField(
                    "useContext",
                    ArrayType(
                        UsageContextSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A legal or geographic region in which the graph definition is intended to be
                # used.
                StructField(
                    "jurisdiction",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Explaination of why this graph definition is needed and why it has been
                # designed as it has.
                StructField("purpose", StringType(), True),
                # The type of FHIR resource at which instances of this graph start.
                StructField("start", StringType(), True),
                # The profile that describes the use of the base resource.
                StructField("profile", StringType(), True),
                # Links this graph makes rules about.
                StructField(
                    "link",
                    ArrayType(
                        GraphDefinition_LinkSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
