from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ExpansionProfile_FixedVersionSchema:
    """
    Resource to define constraints on the Expansion of a FHIR ValueSet.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        Resource to define constraints on the Expansion of a FHIR ValueSet.


        system: The specific system for which to fix the version.

        version: The version of the code system from which codes in the expansion should be
            included.

        mode: How to manage the intersection between a fixed version in a value set, and
            this fixed version of the system in the expansion profile.

        """
        if (
            max_recursion_limit
            and nesting_list.count("ExpansionProfile_FixedVersion") >=
            max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + [
            "ExpansionProfile_FixedVersion"
        ]
        schema = StructType(
            [
                # The specific system for which to fix the version.
                StructField("system", StringType(), True),
                # The version of the code system from which codes in the expansion should be
                # included.
                StructField("version", StringType(), True),
                # How to manage the intersection between a fixed version in a value set, and
                # this fixed version of the system in the expansion profile.
                StructField("mode", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
