from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class EpisodeOfCareSchema:
    """
    An association between a patient and an organization / healthcare provider(s)
    during which time encounters may occur. The managing organization assumes a
    level of responsibility for the patient during this time.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        An association between a patient and an organization / healthcare provider(s)
        during which time encounters may occur. The managing organization assumes a
        level of responsibility for the patient during this time.


        resourceType: This is a EpisodeOfCare resource

        identifier: The EpisodeOfCare may be known by different identifiers for different contexts
            of use, such as when an external agency is tracking the Episode for funding
            purposes.

        status: planned | waitlist | active | onhold | finished | cancelled.

        statusHistory: The history of statuses that the EpisodeOfCare has been through (without
            requiring processing the history of the resource).

        type: A classification of the type of episode of care; e.g. specialist referral,
            disease management, type of funded care.

        diagnosis: The list of diagnosis relevant to this episode of care.

        patient: The patient who is the focus of this episode of care.

        managingOrganization: The organization that has assumed the specific responsibilities for the
            specified duration.

        period: The interval during which the managing organization assumes the defined
            responsibility.

        referralRequest: Referral Request(s) that are fulfilled by this EpisodeOfCare, incoming
            referrals.

        careManager: The practitioner that is the care manager/care co-ordinator for this patient.

        team: The list of practitioners that may be facilitating this episode of care for
            specific purposes.

        account: The set of accounts that may be used for billing for this EpisodeOfCare.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.episodeofcare_statushistory import EpisodeOfCare_StatusHistorySchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.episodeofcare_diagnosis import EpisodeOfCare_DiagnosisSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        if (
            max_recursion_limit
            and nesting_list.count("EpisodeOfCare") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["EpisodeOfCare"]
        schema = StructType(
            [
                # This is a EpisodeOfCare resource
                StructField("resourceType", StringType(), True),
                # The EpisodeOfCare may be known by different identifiers for different contexts
                # of use, such as when an external agency is tracking the Episode for funding
                # purposes.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # planned | waitlist | active | onhold | finished | cancelled.
                StructField("status", StringType(), True),
                # The history of statuses that the EpisodeOfCare has been through (without
                # requiring processing the history of the resource).
                StructField(
                    "statusHistory",
                    ArrayType(
                        EpisodeOfCare_StatusHistorySchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A classification of the type of episode of care; e.g. specialist referral,
                # disease management, type of funded care.
                StructField(
                    "type",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The list of diagnosis relevant to this episode of care.
                StructField(
                    "diagnosis",
                    ArrayType(
                        EpisodeOfCare_DiagnosisSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The patient who is the focus of this episode of care.
                StructField(
                    "patient",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The organization that has assumed the specific responsibilities for the
                # specified duration.
                StructField(
                    "managingOrganization",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The interval during which the managing organization assumes the defined
                # responsibility.
                StructField(
                    "period",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Referral Request(s) that are fulfilled by this EpisodeOfCare, incoming
                # referrals.
                StructField(
                    "referralRequest",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The practitioner that is the care manager/care co-ordinator for this patient.
                StructField(
                    "careManager",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The list of practitioners that may be facilitating this episode of care for
                # specific purposes.
                StructField(
                    "team",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The set of accounts that may be used for billing for this EpisodeOfCare.
                StructField(
                    "account",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
