from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class EncounterSchema:
    """
    An interaction between a patient and healthcare provider(s) for the purpose of
    providing healthcare service(s) or assessing the health status of a patient.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        An interaction between a patient and healthcare provider(s) for the purpose of
        providing healthcare service(s) or assessing the health status of a patient.


        resourceType: This is a Encounter resource

        identifier: Identifier(s) by which this encounter is known.

        status: planned | arrived | triaged | in-progress | onleave | finished | cancelled +.

        statusHistory: The status history permits the encounter resource to contain the status
            history without needing to read through the historical versions of the
            resource, or even have the server store them.

        class: inpatient | outpatient | ambulatory | emergency +.

        classHistory: The class history permits the tracking of the encounters transitions without
            needing to go  through the resource history.

            This would be used for a case where an admission starts of as an emergency
            encounter, then transisions into an inpatient scenario. Doing this and not
            restarting a new encounter ensures that any lab/diagnostic results can more
            easily follow the patient and not require re-processing and not get lost or
            cancelled during a kindof discharge from emergency to inpatient.

        type: Specific type of encounter (e.g. e-mail consultation, surgical day-care,
            skilled nursing, rehabilitation).

        priority: Indicates the urgency of the encounter.

        subject: The patient ro group present at the encounter.

        episodeOfCare: Where a specific encounter should be classified as a part of a specific
            episode(s) of care this field should be used. This association can facilitate
            grouping of related encounters together for a specific purpose, such as
            government reporting, issue tracking, association via a common problem.  The
            association is recorded on the encounter as these are typically created after
            the episode of care, and grouped on entry rather than editing the episode of
            care to append another encounter to it (the episode of care could span years).

        incomingReferral: The referral request this encounter satisfies (incoming referral).

        participant: The list of people responsible for providing the service.

        appointment: The appointment that scheduled this encounter.

        period: The start and end time of the encounter.

        length: Quantity of time the encounter lasted. This excludes the time during leaves of
            absence.

        reason: Reason the encounter takes place, expressed as a code. For admissions, this
            can be used for a coded admission diagnosis.

        diagnosis: The list of diagnosis relevant to this encounter.

        account: The set of accounts that may be used for billing for this Encounter.

        hospitalization: Details about the admission to a healthcare service.

        location: List of locations where  the patient has been during this encounter.

        serviceProvider: An organization that is in charge of maintaining the information of this
            Encounter (e.g. who maintains the report or the master service catalog item,
            etc.). This MAY be the same as the organization on the Patient record, however
            it could be different. This MAY not be not the Service Delivery Location's
            Organization.

        partOf: Another Encounter of which this encounter is a part of (administratively or in
            time).

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.encounter_statushistory import Encounter_StatusHistorySchema
        from spark_fhir_schemas.stu3.complex_types.coding import CodingSchema
        from spark_fhir_schemas.stu3.complex_types.encounter_classhistory import Encounter_ClassHistorySchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.encounter_participant import Encounter_ParticipantSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.duration import DurationSchema
        from spark_fhir_schemas.stu3.complex_types.encounter_diagnosis import Encounter_DiagnosisSchema
        from spark_fhir_schemas.stu3.complex_types.encounter_hospitalization import Encounter_HospitalizationSchema
        from spark_fhir_schemas.stu3.complex_types.encounter_location import Encounter_LocationSchema
        if (
            max_recursion_limit
            and nesting_list.count("Encounter") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Encounter"]
        schema = StructType(
            [
                # This is a Encounter resource
                StructField("resourceType", StringType(), True),
                # Identifier(s) by which this encounter is known.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # planned | arrived | triaged | in-progress | onleave | finished | cancelled +.
                StructField("status", StringType(), True),
                # The status history permits the encounter resource to contain the status
                # history without needing to read through the historical versions of the
                # resource, or even have the server store them.
                StructField(
                    "statusHistory",
                    ArrayType(
                        Encounter_StatusHistorySchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # inpatient | outpatient | ambulatory | emergency +.
                StructField(
                    "class",
                    CodingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The class history permits the tracking of the encounters transitions without
                # needing to go  through the resource history.
                #
                # This would be used for a case where an admission starts of as an emergency
                # encounter, then transisions into an inpatient scenario. Doing this and not
                # restarting a new encounter ensures that any lab/diagnostic results can more
                # easily follow the patient and not require re-processing and not get lost or
                # cancelled during a kindof discharge from emergency to inpatient.
                StructField(
                    "classHistory",
                    ArrayType(
                        Encounter_ClassHistorySchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Specific type of encounter (e.g. e-mail consultation, surgical day-care,
                # skilled nursing, rehabilitation).
                StructField(
                    "type",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Indicates the urgency of the encounter.
                StructField(
                    "priority",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The patient ro group present at the encounter.
                StructField(
                    "subject",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Where a specific encounter should be classified as a part of a specific
                # episode(s) of care this field should be used. This association can facilitate
                # grouping of related encounters together for a specific purpose, such as
                # government reporting, issue tracking, association via a common problem.  The
                # association is recorded on the encounter as these are typically created after
                # the episode of care, and grouped on entry rather than editing the episode of
                # care to append another encounter to it (the episode of care could span years).
                StructField(
                    "episodeOfCare",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The referral request this encounter satisfies (incoming referral).
                StructField(
                    "incomingReferral",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The list of people responsible for providing the service.
                StructField(
                    "participant",
                    ArrayType(
                        Encounter_ParticipantSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The appointment that scheduled this encounter.
                StructField(
                    "appointment",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The start and end time of the encounter.
                StructField(
                    "period",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Quantity of time the encounter lasted. This excludes the time during leaves of
                # absence.
                StructField(
                    "length",
                    DurationSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Reason the encounter takes place, expressed as a code. For admissions, this
                # can be used for a coded admission diagnosis.
                StructField(
                    "reason",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The list of diagnosis relevant to this encounter.
                StructField(
                    "diagnosis",
                    ArrayType(
                        Encounter_DiagnosisSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The set of accounts that may be used for billing for this Encounter.
                StructField(
                    "account",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Details about the admission to a healthcare service.
                StructField(
                    "hospitalization",
                    Encounter_HospitalizationSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # List of locations where  the patient has been during this encounter.
                StructField(
                    "location",
                    ArrayType(
                        Encounter_LocationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # An organization that is in charge of maintaining the information of this
                # Encounter (e.g. who maintains the report or the master service catalog item,
                # etc.). This MAY be the same as the organization on the Patient record, however
                # it could be different. This MAY not be not the Service Delivery Location's
                # Organization.
                StructField(
                    "serviceProvider",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Another Encounter of which this encounter is a part of (administratively or in
                # time).
                StructField(
                    "partOf",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
