from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class DeviceRequestSchema:
    """
    Represents a request for a patient to employ a medical device. The device may
    be an implantable device, or an external assistive device, such as a walker.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        Represents a request for a patient to employ a medical device. The device may
        be an implantable device, or an external assistive device, such as a walker.


        resourceType: This is a DeviceRequest resource

        identifier: Identifiers assigned to this order by the orderer or by the receiver.

        definition: Protocol or definition followed by this request. For example: The proposed act
            must be performed if the indicated conditions occur, e.g.., shortness of
            breath, SpO2 less than x%.

        basedOn: Plan/proposal/order fulfilled by this request.

        priorRequest: The request takes the place of the referenced completed or terminated
            request(s).

        groupIdentifier: Composite request this is part of.

        status: The status of the request.

        intent: Whether the request is a proposal, plan, an original order or a reflex order.

        priority: Indicates how quickly the {{title}} should be addressed with respect to other
            requests.

        codeReference: The details of the device to be used.

        codeCodeableConcept: The details of the device to be used.

        subject: The patient who will use the device.

        context: An encounter that provides additional context in which this request is made.

        occurrenceDateTime: The timing schedule for the use of the device. The Schedule data type allows
            many different expressions, for example. "Every 8 hours"; "Three times a day";
            "1/2 an hour before breakfast for 10 days from 23-Dec 2011:"; "15 Oct 2013, 17
            Oct 2013 and 1 Nov 2013".

        occurrencePeriod: The timing schedule for the use of the device. The Schedule data type allows
            many different expressions, for example. "Every 8 hours"; "Three times a day";
            "1/2 an hour before breakfast for 10 days from 23-Dec 2011:"; "15 Oct 2013, 17
            Oct 2013 and 1 Nov 2013".

        occurrenceTiming: The timing schedule for the use of the device. The Schedule data type allows
            many different expressions, for example. "Every 8 hours"; "Three times a day";
            "1/2 an hour before breakfast for 10 days from 23-Dec 2011:"; "15 Oct 2013, 17
            Oct 2013 and 1 Nov 2013".

        authoredOn: When the request transitioned to being actionable.

        requester: The individual who initiated the request and has responsibility for its
            activation.

        performerType: Desired type of performer for doing the diagnostic testing.

        performer: The desired perfomer for doing the diagnostic testing.

        reasonCode: Reason or justification for the use of this device.

        reasonReference: Reason or justification for the use of this device.

        supportingInfo: Additional clinical information about the patient that may influence the
            request fulfilment.  For example, this may includes body where on the
            subject's the device will be used ( i.e. the target site).

        note: Details about this request that were not represented at all or sufficiently in
            one of the attributes provided in a class. These may include for example a
            comment, an instruction, or a note associated with the statement.

        relevantHistory: Key events in the history of the request.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.timing import TimingSchema
        from spark_fhir_schemas.stu3.complex_types.devicerequest_requester import DeviceRequest_RequesterSchema
        from spark_fhir_schemas.stu3.complex_types.annotation import AnnotationSchema
        if (
            max_recursion_limit
            and nesting_list.count("DeviceRequest") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["DeviceRequest"]
        schema = StructType(
            [
                # This is a DeviceRequest resource
                StructField("resourceType", StringType(), True),
                # Identifiers assigned to this order by the orderer or by the receiver.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Protocol or definition followed by this request. For example: The proposed act
                # must be performed if the indicated conditions occur, e.g.., shortness of
                # breath, SpO2 less than x%.
                StructField(
                    "definition",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Plan/proposal/order fulfilled by this request.
                StructField(
                    "basedOn",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The request takes the place of the referenced completed or terminated
                # request(s).
                StructField(
                    "priorRequest",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Composite request this is part of.
                StructField(
                    "groupIdentifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The status of the request.
                StructField("status", StringType(), True),
                # Whether the request is a proposal, plan, an original order or a reflex order.
                StructField(
                    "intent",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Indicates how quickly the {{title}} should be addressed with respect to other
                # requests.
                StructField("priority", StringType(), True),
                # The details of the device to be used.
                StructField(
                    "codeReference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The details of the device to be used.
                StructField(
                    "codeCodeableConcept",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The patient who will use the device.
                StructField(
                    "subject",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # An encounter that provides additional context in which this request is made.
                StructField(
                    "context",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The timing schedule for the use of the device. The Schedule data type allows
                # many different expressions, for example. "Every 8 hours"; "Three times a day";
                # "1/2 an hour before breakfast for 10 days from 23-Dec 2011:"; "15 Oct 2013, 17
                # Oct 2013 and 1 Nov 2013".
                StructField("occurrenceDateTime", StringType(), True),
                # The timing schedule for the use of the device. The Schedule data type allows
                # many different expressions, for example. "Every 8 hours"; "Three times a day";
                # "1/2 an hour before breakfast for 10 days from 23-Dec 2011:"; "15 Oct 2013, 17
                # Oct 2013 and 1 Nov 2013".
                StructField(
                    "occurrencePeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The timing schedule for the use of the device. The Schedule data type allows
                # many different expressions, for example. "Every 8 hours"; "Three times a day";
                # "1/2 an hour before breakfast for 10 days from 23-Dec 2011:"; "15 Oct 2013, 17
                # Oct 2013 and 1 Nov 2013".
                StructField(
                    "occurrenceTiming",
                    TimingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # When the request transitioned to being actionable.
                StructField("authoredOn", StringType(), True),
                # The individual who initiated the request and has responsibility for its
                # activation.
                StructField(
                    "requester",
                    DeviceRequest_RequesterSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Desired type of performer for doing the diagnostic testing.
                StructField(
                    "performerType",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The desired perfomer for doing the diagnostic testing.
                StructField(
                    "performer",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Reason or justification for the use of this device.
                StructField(
                    "reasonCode",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Reason or justification for the use of this device.
                StructField(
                    "reasonReference",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Additional clinical information about the patient that may influence the
                # request fulfilment.  For example, this may includes body where on the
                # subject's the device will be used ( i.e. the target site).
                StructField(
                    "supportingInfo",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Details about this request that were not represented at all or sufficiently in
                # one of the attributes provided in a class. These may include for example a
                # comment, an instruction, or a note associated with the statement.
                StructField(
                    "note",
                    ArrayType(
                        AnnotationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Key events in the history of the request.
                StructField(
                    "relevantHistory",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
