from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class DeviceMetricSchema:
    """
    Describes a measurement, calculation or setting capability of a medical
    device.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        Describes a measurement, calculation or setting capability of a medical
        device.


        resourceType: This is a DeviceMetric resource

        identifier: Describes the unique identification of this metric that has been assigned by
            the device or gateway software. For example: handle ID.  It should be noted
            that in order to make the identifier unique, the system element of the
            identifier should be set to the unique identifier of the device.

        type: Describes the type of the metric. For example: Heart Rate, PEEP Setting, etc.

        unit: Describes the unit that an observed value determined for this metric will
            have. For example: Percent, Seconds, etc.

        source: Describes the link to the  Device that this DeviceMetric belongs to and that
            contains administrative device information such as manufacturer, serial
            number, etc.

        parent: Describes the link to the  DeviceComponent that this DeviceMetric belongs to
            and that provide information about the location of this DeviceMetric in the
            containment structure of the parent Device. An example would be a
            DeviceComponent that represents a Channel. This reference can be used by a
            client application to distinguish DeviceMetrics that have the same type, but
            should be interpreted based on their containment location.

        operationalStatus: Indicates current operational state of the device. For example: On, Off,
            Standby, etc.

        color: Describes the color representation for the metric. This is often used to aid
            clinicians to track and identify parameter types by color. In practice,
            consider a Patient Monitor that has ECG/HR and Pleth for example; the
            parameters are displayed in different characteristic colors, such as HR-blue,
            BP-green, and PR and SpO2- magenta.

        category: Indicates the category of the observation generation process. A DeviceMetric
            can be for example a setting, measurement, or calculation.

        measurementPeriod: Describes the measurement repetition time. This is not necessarily the same as
            the update period. The measurement repetition time can range from milliseconds
            up to hours. An example for a measurement repetition time in the range of
            milliseconds is the sampling rate of an ECG. An example for a measurement
            repetition time in the range of hours is a NIBP that is triggered
            automatically every hour. The update period may be different than the
            measurement repetition time, if the device does not update the published
            observed value with the same frequency as it was measured.

        calibration: Describes the calibrations that have been performed or that are required to be
            performed.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.timing import TimingSchema
        from spark_fhir_schemas.stu3.complex_types.devicemetric_calibration import DeviceMetric_CalibrationSchema
        if (
            max_recursion_limit
            and nesting_list.count("DeviceMetric") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["DeviceMetric"]
        schema = StructType(
            [
                # This is a DeviceMetric resource
                StructField("resourceType", StringType(), True),
                # Describes the unique identification of this metric that has been assigned by
                # the device or gateway software. For example: handle ID.  It should be noted
                # that in order to make the identifier unique, the system element of the
                # identifier should be set to the unique identifier of the device.
                StructField(
                    "identifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Describes the type of the metric. For example: Heart Rate, PEEP Setting, etc.
                StructField(
                    "type",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Describes the unit that an observed value determined for this metric will
                # have. For example: Percent, Seconds, etc.
                StructField(
                    "unit",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Describes the link to the  Device that this DeviceMetric belongs to and that
                # contains administrative device information such as manufacturer, serial
                # number, etc.
                StructField(
                    "source",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Describes the link to the  DeviceComponent that this DeviceMetric belongs to
                # and that provide information about the location of this DeviceMetric in the
                # containment structure of the parent Device. An example would be a
                # DeviceComponent that represents a Channel. This reference can be used by a
                # client application to distinguish DeviceMetrics that have the same type, but
                # should be interpreted based on their containment location.
                StructField(
                    "parent",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Indicates current operational state of the device. For example: On, Off,
                # Standby, etc.
                StructField("operationalStatus", StringType(), True),
                # Describes the color representation for the metric. This is often used to aid
                # clinicians to track and identify parameter types by color. In practice,
                # consider a Patient Monitor that has ECG/HR and Pleth for example; the
                # parameters are displayed in different characteristic colors, such as HR-blue,
                # BP-green, and PR and SpO2- magenta.
                StructField("color", StringType(), True),
                # Indicates the category of the observation generation process. A DeviceMetric
                # can be for example a setting, measurement, or calculation.
                StructField("category", StringType(), True),
                # Describes the measurement repetition time. This is not necessarily the same as
                # the update period. The measurement repetition time can range from milliseconds
                # up to hours. An example for a measurement repetition time in the range of
                # milliseconds is the sampling rate of an ECG. An example for a measurement
                # repetition time in the range of hours is a NIBP that is triggered
                # automatically every hour. The update period may be different than the
                # measurement repetition time, if the device does not update the published
                # observed value with the same frequency as it was measured.
                StructField(
                    "measurementPeriod",
                    TimingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Describes the calibrations that have been performed or that are required to be
                # performed.
                StructField(
                    "calibration",
                    ArrayType(
                        DeviceMetric_CalibrationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
