from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class DeviceComponent_ProductionSpecificationSchema:
    """
    The characteristics, operational status and capabilities of a medical-related
    component of a medical device.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        The characteristics, operational status and capabilities of a medical-related
        component of a medical device.


        specType: The specification type, such as, serial number, part number, hardware
            revision, software revision, etc.

        componentId: The internal component unique identification. This is a provision for
            manufacture specific standard components using a private OID. 11073-10101 has
            a partition for private OID semantic that the manufacturer can make use of.

        productionSpec: The printable string defining the component.

        """
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        if (
            max_recursion_limit
            and nesting_list.count("DeviceComponent_ProductionSpecification")
            >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + [
            "DeviceComponent_ProductionSpecification"
        ]
        schema = StructType(
            [
                # The specification type, such as, serial number, part number, hardware
                # revision, software revision, etc.
                StructField(
                    "specType",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The internal component unique identification. This is a provision for
                # manufacture specific standard components using a private OID. 11073-10101 has
                # a partition for private OID semantic that the manufacturer can make use of.
                StructField(
                    "componentId",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The printable string defining the component.
                StructField("productionSpec", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
