from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Device_UdiSchema:
    """
    This resource identifies an instance or a type of a manufactured item that is
    used in the provision of healthcare without being substantially changed
    through that activity. The device may be a medical or non-medical device.
    Medical devices include durable (reusable) medical equipment, implantable
    devices, as well as disposable equipment used for diagnostic, treatment, and
    research for healthcare and public health.  Non-medical devices may include
    items such as a machine, cellphone, computer, application, etc.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        This resource identifies an instance or a type of a manufactured item that is
        used in the provision of healthcare without being substantially changed
        through that activity. The device may be a medical or non-medical device.
        Medical devices include durable (reusable) medical equipment, implantable
        devices, as well as disposable equipment used for diagnostic, treatment, and
        research for healthcare and public health.  Non-medical devices may include
        items such as a machine, cellphone, computer, application, etc.


        deviceIdentifier: The device identifier (DI) is a mandatory, fixed portion of a UDI that
            identifies the labeler and the specific version or model of a device.

        name: Name of device as used in labeling or catalog.

        jurisdiction: The identity of the authoritative source for UDI generation within a
            jurisdiction.  All UDIs are globally unique within a single namespace. with
            the appropriate repository uri as the system.  For example,  UDIs of devices
            managed in the U.S. by the FDA, the value is
            http://hl7.org/fhir/NamingSystem/fda-udi.

        carrierHRF: The full UDI carrier as the human readable form (HRF) representation of the
            barcode string as printed on the packaging of the device.

        carrierAIDC: The full UDI carrier of the Automatic Identification and Data Capture (AIDC)
            technology representation of the barcode string as printed on the packaging of
            the device - E.g a barcode or RFID.   Because of limitations on character sets
            in XML and the need to round-trip JSON data through XML, AIDC Formats *SHALL*
            be base64 encoded.

        issuer: Organization that is charged with issuing UDIs for devices.  For example, the
            US FDA issuers include :
            1) GS1:
            http://hl7.org/fhir/NamingSystem/gs1-di,
            2) HIBCC:
            http://hl7.org/fhir/NamingSystem/hibcc-dI,
            3) ICCBBA for blood containers:
            http://hl7.org/fhir/NamingSystem/iccbba-blood-di,
            4) ICCBA for other devices:
            http://hl7.org/fhir/NamingSystem/iccbba-other-di.

        entryType: A coded entry to indicate how the data was entered.

        """
        if (
            max_recursion_limit
            and nesting_list.count("Device_Udi") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Device_Udi"]
        schema = StructType(
            [
                # The device identifier (DI) is a mandatory, fixed portion of a UDI that
                # identifies the labeler and the specific version or model of a device.
                StructField("deviceIdentifier", StringType(), True),
                # Name of device as used in labeling or catalog.
                StructField("name", StringType(), True),
                # The identity of the authoritative source for UDI generation within a
                # jurisdiction.  All UDIs are globally unique within a single namespace. with
                # the appropriate repository uri as the system.  For example,  UDIs of devices
                # managed in the U.S. by the FDA, the value is
                # http://hl7.org/fhir/NamingSystem/fda-udi.
                StructField("jurisdiction", StringType(), True),
                # The full UDI carrier as the human readable form (HRF) representation of the
                # barcode string as printed on the packaging of the device.
                StructField("carrierHRF", StringType(), True),
                # The full UDI carrier of the Automatic Identification and Data Capture (AIDC)
                # technology representation of the barcode string as printed on the packaging of
                # the device - E.g a barcode or RFID.   Because of limitations on character sets
                # in XML and the need to round-trip JSON data through XML, AIDC Formats *SHALL*
                # be base64 encoded.
                StructField("carrierAIDC", StringType(), True),
                # Organization that is charged with issuing UDIs for devices.  For example, the
                # US FDA issuers include :
                # 1) GS1:
                # http://hl7.org/fhir/NamingSystem/gs1-di,
                # 2) HIBCC:
                # http://hl7.org/fhir/NamingSystem/hibcc-dI,
                # 3) ICCBBA for blood containers:
                # http://hl7.org/fhir/NamingSystem/iccbba-blood-di,
                # 4) ICCBA for other devices:
                # http://hl7.org/fhir/NamingSystem/iccbba-other-di.
                StructField("issuer", StringType(), True),
                # A coded entry to indicate how the data was entered.
                StructField("entryType", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
