from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Consent_PolicySchema:
    """
    A record of a healthcare consumer’s policy choices, which permits or denies
    identified recipient(s) or recipient role(s) to perform one or more actions
    within a given policy context, for specific purposes and periods of time.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A record of a healthcare consumer’s policy choices, which permits or denies
        identified recipient(s) or recipient role(s) to perform one or more actions
        within a given policy context, for specific purposes and periods of time.


        authority: Entity or Organization having regulatory jurisdiction or accountability for
             enforcing policies pertaining to Consent Directives.

        uri: The references to the policies that are included in this consent scope.
            Policies may be organizational, but are often defined jurisdictionally, or in
            law.

        """
        if (
            max_recursion_limit
            and nesting_list.count("Consent_Policy") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Consent_Policy"]
        schema = StructType(
            [
                # Entity or Organization having regulatory jurisdiction or accountability for
                #  enforcing policies pertaining to Consent Directives.
                StructField("authority", StringType(), True),
                # The references to the policies that are included in this consent scope.
                # Policies may be organizational, but are often defined jurisdictionally, or in
                # law.
                StructField("uri", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
