from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Consent_ExceptSchema:
    """
    A record of a healthcare consumer’s policy choices, which permits or denies
    identified recipient(s) or recipient role(s) to perform one or more actions
    within a given policy context, for specific purposes and periods of time.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A record of a healthcare consumer’s policy choices, which permits or denies
        identified recipient(s) or recipient role(s) to perform one or more actions
        within a given policy context, for specific purposes and periods of time.


        type: Action  to take - permit or deny - when the exception conditions are met.

        period: The timeframe in this exception is valid.

        actor: Who or what is controlled by this Exception. Use group to identify a set of
            actors by some property they share (e.g. 'admitting officers').

        action: Actions controlled by this Exception.

        securityLabel: A set of security labels that define which resources are controlled by this
            exception. If more than one label is specified, all resources must have all
            the specified labels.

        purpose: The context of the activities a user is taking - why the user is accessing the
            data - that are controlled by this exception.

        class: The class of information covered by this exception. The type can be a FHIR
            resource type, a profile on a type, or a CDA document, or some other type that
            indicates what sort of information the consent relates to.

        code: If this code is found in an instance, then the exception applies.

        dataPeriod: Clinical or Operational Relevant period of time that bounds the data
            controlled by this exception.

        data: The resources controlled by this exception, if specific resources are
            referenced.

        """
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.consent_actor1 import Consent_Actor1Schema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.coding import CodingSchema
        from spark_fhir_schemas.stu3.complex_types.consent_data1 import Consent_Data1Schema
        if (
            max_recursion_limit
            and nesting_list.count("Consent_Except") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Consent_Except"]
        schema = StructType(
            [
                # Action  to take - permit or deny - when the exception conditions are met.
                StructField("type", StringType(), True),
                # The timeframe in this exception is valid.
                StructField(
                    "period",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Who or what is controlled by this Exception. Use group to identify a set of
                # actors by some property they share (e.g. 'admitting officers').
                StructField(
                    "actor",
                    ArrayType(
                        Consent_Actor1Schema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Actions controlled by this Exception.
                StructField(
                    "action",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A set of security labels that define which resources are controlled by this
                # exception. If more than one label is specified, all resources must have all
                # the specified labels.
                StructField(
                    "securityLabel",
                    ArrayType(
                        CodingSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The context of the activities a user is taking - why the user is accessing the
                # data - that are controlled by this exception.
                StructField(
                    "purpose",
                    ArrayType(
                        CodingSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The class of information covered by this exception. The type can be a FHIR
                # resource type, a profile on a type, or a CDA document, or some other type that
                # indicates what sort of information the consent relates to.
                StructField(
                    "class",
                    ArrayType(
                        CodingSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # If this code is found in an instance, then the exception applies.
                StructField(
                    "code",
                    ArrayType(
                        CodingSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Clinical or Operational Relevant period of time that bounds the data
                # controlled by this exception.
                StructField(
                    "dataPeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The resources controlled by this exception, if specific resources are
                # referenced.
                StructField(
                    "data",
                    ArrayType(
                        Consent_Data1Schema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
