from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ConceptMap_UnmappedSchema:
    """
    A statement of relationships from one set of concepts to one or more other
    concepts - either code systems or data elements, or classes in class models.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A statement of relationships from one set of concepts to one or more other
        concepts - either code systems or data elements, or classes in class models.


        mode: Defines which action to take if there is no match in the group. One of 3
            actions is possible: use the unmapped code (this is useful when doing a
            mapping between versions, and only a few codes have changed), use a fixed code
            (a default code), or alternatively, a reference to a different concept map can
            be provided (by canonical URL).

        code: The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped
            to a single fixed code.

        display: The display for the code. The display is only provided to help editors when
            editing the concept map.

        url: The canonical URL of the map to use if this map contains no mapping.

        """
        if (
            max_recursion_limit and
            nesting_list.count("ConceptMap_Unmapped") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ConceptMap_Unmapped"]
        schema = StructType(
            [
                # Defines which action to take if there is no match in the group. One of 3
                # actions is possible: use the unmapped code (this is useful when doing a
                # mapping between versions, and only a few codes have changed), use a fixed code
                # (a default code), or alternatively, a reference to a different concept map can
                # be provided (by canonical URL).
                StructField("mode", StringType(), True),
                # The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped
                # to a single fixed code.
                StructField("code", StringType(), True),
                # The display for the code. The display is only provided to help editors when
                # editing the concept map.
                StructField("display", StringType(), True),
                # The canonical URL of the map to use if this map contains no mapping.
                StructField("url", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
