from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ConceptMap_TargetSchema:
    """
    A statement of relationships from one set of concepts to one or more other
    concepts - either code systems or data elements, or classes in class models.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A statement of relationships from one set of concepts to one or more other
        concepts - either code systems or data elements, or classes in class models.


        code: Identity (code or path) or the element/item that the map refers to.

        display: The display for the code. The display is only provided to help editors when
            editing the concept map.

        equivalence: The equivalence between the source and target concepts (counting for the
            dependencies and products). The equivalence is read from target to source
            (e.g. the target is 'wider' than the source).

        comment: A description of status/issues in mapping that conveys additional information
            not represented in  the structured data.

        dependsOn: A set of additional dependencies for this mapping to hold. This mapping is
            only applicable if the specified element can be resolved, and it has the
            specified value.

        product: A set of additional outcomes from this mapping to other elements. To properly
            execute this mapping, the specified element must be mapped to some data
            element or source that is in context. The mapping may still be useful without
            a place for the additional data elements, but the equivalence cannot be relied
            on.

        """
        from spark_fhir_schemas.stu3.complex_types.conceptmap_dependson import ConceptMap_DependsOnSchema
        if (
            max_recursion_limit
            and nesting_list.count("ConceptMap_Target") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ConceptMap_Target"]
        schema = StructType(
            [
                # Identity (code or path) or the element/item that the map refers to.
                StructField("code", StringType(), True),
                # The display for the code. The display is only provided to help editors when
                # editing the concept map.
                StructField("display", StringType(), True),
                # The equivalence between the source and target concepts (counting for the
                # dependencies and products). The equivalence is read from target to source
                # (e.g. the target is 'wider' than the source).
                StructField("equivalence", StringType(), True),
                # A description of status/issues in mapping that conveys additional information
                # not represented in  the structured data.
                StructField("comment", StringType(), True),
                # A set of additional dependencies for this mapping to hold. This mapping is
                # only applicable if the specified element can be resolved, and it has the
                # specified value.
                StructField(
                    "dependsOn",
                    ArrayType(
                        ConceptMap_DependsOnSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A set of additional outcomes from this mapping to other elements. To properly
                # execute this mapping, the specified element must be mapped to some data
                # element or source that is in context. The mapping may still be useful without
                # a place for the additional data elements, but the equivalence cannot be relied
                # on.
                StructField(
                    "product",
                    ArrayType(
                        ConceptMap_DependsOnSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
