from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ClaimResponse_AddItemSchema:
    """
    This resource provides the adjudication details from the processing of a Claim
    resource.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        This resource provides the adjudication details from the processing of a Claim
        resource.


        sequenceLinkId: List of input service items which this service line is intended to replace.

        revenue: The type of reveneu or cost center providing the product and/or service.

        category: Health Care Service Type Codes  to identify the classification of service or
            benefits.

        service: A code to indicate the Professional Service or Product supplied.

        modifier: Item typification or modifiers codes, eg for Oral whether the treatment is
            cosmetic or associated with TMJ, or for medical whether the treatment was
            outside the clinic or out of office hours.

        fee: The fee charged for the professional service or product..

        noteNumber: A list of note references to the notes provided below.

        adjudication: The adjudications results.

        detail: The second tier service adjudications for payor added services.

        """
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.money import MoneySchema
        from spark_fhir_schemas.stu3.complex_types.claimresponse_adjudication import ClaimResponse_AdjudicationSchema
        from spark_fhir_schemas.stu3.complex_types.claimresponse_detail1 import ClaimResponse_Detail1Schema
        if (
            max_recursion_limit and
            nesting_list.count("ClaimResponse_AddItem") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ClaimResponse_AddItem"]
        schema = StructType(
            [
                # List of input service items which this service line is intended to replace.
                # The type of reveneu or cost center providing the product and/or service.
                StructField(
                    "revenue",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Health Care Service Type Codes  to identify the classification of service or
                # benefits.
                StructField(
                    "category",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # A code to indicate the Professional Service or Product supplied.
                StructField(
                    "service",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Item typification or modifiers codes, eg for Oral whether the treatment is
                # cosmetic or associated with TMJ, or for medical whether the treatment was
                # outside the clinic or out of office hours.
                StructField(
                    "modifier",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The fee charged for the professional service or product..
                StructField(
                    "fee",
                    MoneySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # A list of note references to the notes provided below.
                # The adjudications results.
                StructField(
                    "adjudication",
                    ArrayType(
                        ClaimResponse_AdjudicationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The second tier service adjudications for payor added services.
                StructField(
                    "detail",
                    ArrayType(
                        ClaimResponse_Detail1Schema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
