from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class CarePlanSchema:
    """
    Describes the intention of how one or more practitioners intend to deliver
    care for a particular patient, group or community for a period of time,
    possibly limited to care for a specific condition or set of conditions.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        Describes the intention of how one or more practitioners intend to deliver
        care for a particular patient, group or community for a period of time,
        possibly limited to care for a specific condition or set of conditions.


        resourceType: This is a CarePlan resource

        identifier: This records identifiers associated with this care plan that are defined by
            business processes and/or used to refer to it when a direct URL reference to
            the resource itself is not appropriate (e.g. in CDA documents, or in written /
            printed documentation).

        definition: Identifies the protocol, questionnaire, guideline or other specification the
            care plan should be conducted in accordance with.

        basedOn: A care plan that is fulfilled in whole or in part by this care plan.

        replaces: Completed or terminated care plan whose function is taken by this new care
            plan.

        partOf: A larger care plan of which this particular care plan is a component or step.

        status: Indicates whether the plan is currently being acted upon, represents future
            intentions or is now a historical record.

        intent: Indicates the level of authority/intentionality associated with the care plan
            and where the care plan fits into the workflow chain.

        category: Identifies what "kind" of plan this is to support differentiation between
            multiple co-existing plans; e.g. "Home health", "psychiatric", "asthma",
            "disease management", "wellness plan", etc.

        title: Human-friendly name for the CarePlan.

        description: A description of the scope and nature of the plan.

        subject: Identifies the patient or group whose intended care is described by the plan.

        context: Identifies the original context in which this particular CarePlan was created.

        period: Indicates when the plan did (or is intended to) come into effect and end.

        author: Identifies the individual(s) or ogranization who is responsible for the
            content of the care plan.

        careTeam: Identifies all people and organizations who are expected to be involved in the
            care envisioned by this plan.

        addresses: Identifies the conditions/problems/concerns/diagnoses/etc. whose management
            and/or mitigation are handled by this plan.

        supportingInfo: Identifies portions of the patient's record that specifically influenced the
            formation of the plan.  These might include co-morbidities, recent procedures,
            limitations, recent assessments, etc.

        goal: Describes the intended objective(s) of carrying out the care plan.

        activity: Identifies a planned action to occur as part of the plan.  For example, a
            medication to be used, lab tests to perform, self-monitoring, education, etc.

        note: General notes about the care plan not covered elsewhere.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.careplan_activity import CarePlan_ActivitySchema
        from spark_fhir_schemas.stu3.complex_types.annotation import AnnotationSchema
        if (
            max_recursion_limit
            and nesting_list.count("CarePlan") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["CarePlan"]
        schema = StructType(
            [
                # This is a CarePlan resource
                StructField("resourceType", StringType(), True),
                # This records identifiers associated with this care plan that are defined by
                # business processes and/or used to refer to it when a direct URL reference to
                # the resource itself is not appropriate (e.g. in CDA documents, or in written /
                # printed documentation).
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Identifies the protocol, questionnaire, guideline or other specification the
                # care plan should be conducted in accordance with.
                StructField(
                    "definition",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A care plan that is fulfilled in whole or in part by this care plan.
                StructField(
                    "basedOn",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Completed or terminated care plan whose function is taken by this new care
                # plan.
                StructField(
                    "replaces",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A larger care plan of which this particular care plan is a component or step.
                StructField(
                    "partOf",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Indicates whether the plan is currently being acted upon, represents future
                # intentions or is now a historical record.
                StructField("status", StringType(), True),
                # Indicates the level of authority/intentionality associated with the care plan
                # and where the care plan fits into the workflow chain.
                StructField("intent", StringType(), True),
                # Identifies what "kind" of plan this is to support differentiation between
                # multiple co-existing plans; e.g. "Home health", "psychiatric", "asthma",
                # "disease management", "wellness plan", etc.
                StructField(
                    "category",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Human-friendly name for the CarePlan.
                StructField("title", StringType(), True),
                # A description of the scope and nature of the plan.
                StructField("description", StringType(), True),
                # Identifies the patient or group whose intended care is described by the plan.
                StructField(
                    "subject",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Identifies the original context in which this particular CarePlan was created.
                StructField(
                    "context",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Indicates when the plan did (or is intended to) come into effect and end.
                StructField(
                    "period",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Identifies the individual(s) or ogranization who is responsible for the
                # content of the care plan.
                StructField(
                    "author",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Identifies all people and organizations who are expected to be involved in the
                # care envisioned by this plan.
                StructField(
                    "careTeam",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Identifies the conditions/problems/concerns/diagnoses/etc. whose management
                # and/or mitigation are handled by this plan.
                StructField(
                    "addresses",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Identifies portions of the patient's record that specifically influenced the
                # formation of the plan.  These might include co-morbidities, recent procedures,
                # limitations, recent assessments, etc.
                StructField(
                    "supportingInfo",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Describes the intended objective(s) of carrying out the care plan.
                StructField(
                    "goal",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Identifies a planned action to occur as part of the plan.  For example, a
                # medication to be used, lab tests to perform, self-monitoring, education, etc.
                StructField(
                    "activity",
                    ArrayType(
                        CarePlan_ActivitySchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # General notes about the care plan not covered elsewhere.
                StructField(
                    "note",
                    ArrayType(
                        AnnotationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
