from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class CapabilityStatement_RestSchema:
    """
    A Capability Statement documents a set of capabilities (behaviors) of a FHIR
    Server that may be used as a statement of actual server functionality or a
    statement of required or desired server implementation.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A Capability Statement documents a set of capabilities (behaviors) of a FHIR
        Server that may be used as a statement of actual server functionality or a
        statement of required or desired server implementation.


        mode: Identifies whether this portion of the statement is describing the ability to
            initiate or receive restful operations.

        documentation: Information about the system's restful capabilities that apply across all
            applications, such as security.

        security: Information about security implementation from an interface perspective - what
            a client needs to know.

        resource: A specification of the restful capabilities of the solution for a specific
            resource type.

        interaction: A specification of restful operations supported by the system.

        searchParam: Search parameters that are supported for searching all resources for
            implementations to support and/or make use of - either references to ones
            defined in the specification, or additional ones defined for/by the
            implementation.

        operation: Definition of an operation or a named query together with its parameters and
            their meaning and type.

        compartment: An absolute URI which is a reference to the definition of a compartment that
            the system supports. The reference is to a CompartmentDefinition resource by
            its canonical URL .

        """
        from spark_fhir_schemas.stu3.complex_types.capabilitystatement_security import CapabilityStatement_SecuritySchema
        from spark_fhir_schemas.stu3.complex_types.capabilitystatement_resource import CapabilityStatement_ResourceSchema
        from spark_fhir_schemas.stu3.complex_types.capabilitystatement_interaction1 import CapabilityStatement_Interaction1Schema
        from spark_fhir_schemas.stu3.complex_types.capabilitystatement_searchparam import CapabilityStatement_SearchParamSchema
        from spark_fhir_schemas.stu3.complex_types.capabilitystatement_operation import CapabilityStatement_OperationSchema
        if (
            max_recursion_limit
            and nesting_list.count("CapabilityStatement_Rest") >=
            max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + [
            "CapabilityStatement_Rest"
        ]
        schema = StructType(
            [
                # Identifies whether this portion of the statement is describing the ability to
                # initiate or receive restful operations.
                StructField("mode", StringType(), True),
                # Information about the system's restful capabilities that apply across all
                # applications, such as security.
                StructField("documentation", StringType(), True),
                # Information about security implementation from an interface perspective - what
                # a client needs to know.
                StructField(
                    "security",
                    CapabilityStatement_SecuritySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # A specification of the restful capabilities of the solution for a specific
                # resource type.
                StructField(
                    "resource",
                    ArrayType(
                        CapabilityStatement_ResourceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # A specification of restful operations supported by the system.
                StructField(
                    "interaction",
                    ArrayType(
                        CapabilityStatement_Interaction1Schema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Search parameters that are supported for searching all resources for
                # implementations to support and/or make use of - either references to ones
                # defined in the specification, or additional ones defined for/by the
                # implementation.
                StructField(
                    "searchParam",
                    ArrayType(
                        CapabilityStatement_SearchParamSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Definition of an operation or a named query together with its parameters and
                # their meaning and type.
                StructField(
                    "operation",
                    ArrayType(
                        CapabilityStatement_OperationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # An absolute URI which is a reference to the definition of a compartment that
                # the system supports. The reference is to a CompartmentDefinition resource by
                # its canonical URL .
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
