from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class BundleSchema:
    """
    A container for a collection of resources.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A container for a collection of resources.


        resourceType: This is a Bundle resource

        identifier: A persistent identifier for the batch that won't change as a batch is copied
            from server to server.

        type: Indicates the purpose of this bundle - how it was intended to be used.

        total: If a set of search matches, this is the total number of matches for the search
            (as opposed to the number of results in this bundle).

        link: A series of links that provide context to this bundle.

        entry: An entry in a bundle resource - will either contain a resource, or information
            about a resource (transactions and history only).

        signature: Digital Signature - base64 encoded. XML-DSIg or a JWT.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.bundle_link import Bundle_LinkSchema
        from spark_fhir_schemas.stu3.complex_types.bundle_entry import Bundle_EntrySchema
        from spark_fhir_schemas.stu3.complex_types.signature import SignatureSchema
        if (
            max_recursion_limit
            and nesting_list.count("Bundle") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Bundle"]
        schema = StructType(
            [
                # This is a Bundle resource
                StructField("resourceType", StringType(), True),
                # A persistent identifier for the batch that won't change as a batch is copied
                # from server to server.
                StructField(
                    "identifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Indicates the purpose of this bundle - how it was intended to be used.
                StructField("type", StringType(), True),
                # If a set of search matches, this is the total number of matches for the search
                # (as opposed to the number of results in this bundle).
                StructField("total", IntegerType(), True),
                # A series of links that provide context to this bundle.
                StructField(
                    "link",
                    ArrayType(
                        Bundle_LinkSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # An entry in a bundle resource - will either contain a resource, or information
                # about a resource (transactions and history only).
                StructField(
                    "entry",
                    ArrayType(
                        Bundle_EntrySchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Digital Signature - base64 encoded. XML-DSIg or a JWT.
                StructField(
                    "signature",
                    SignatureSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
