from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class BinarySchema:
    """
    A binary resource can contain any content, whether text, image, pdf, zip
    archive, etc.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A binary resource can contain any content, whether text, image, pdf, zip
        archive, etc.


        resourceType: This is a Binary resource

        contentType: MimeType of the binary content represented as a standard MimeType (BCP 13).

        securityContext: Treat this binary as if it was this other resource for access control
            purposes.

        content: The actual content, base64 encoded.

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        if (
            max_recursion_limit
            and nesting_list.count("Binary") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Binary"]
        schema = StructType(
            [
                # This is a Binary resource
                StructField("resourceType", StringType(), True),
                # MimeType of the binary content represented as a standard MimeType (BCP 13).
                StructField("contentType", StringType(), True),
                # Treat this binary as if it was this other resource for access control
                # purposes.
                StructField(
                    "securityContext",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The actual content, base64 encoded.
                StructField("content", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
